/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.RecipeToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class AutomaticRecipeUnlockModule
extends Module {
    @Config(description="A list of recipe names that should NOT be added in by default")
    public static List<String> ignoredRecipes = Lists.newArrayList();
    @Config
    public static boolean forceLimitedCrafting = false;
    @Config
    public static boolean disableRecipeBook = false;

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerEntity spe;
        MinecraftServer server;
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity && (server = (spe = (ServerPlayerEntity)player).func_184102_h()) != null) {
            ArrayList<IRecipe> recipes = new ArrayList<IRecipe>(server.func_199529_aN().func_199510_b());
            recipes.removeIf(recipe -> ignoredRecipes.contains(Objects.toString(recipe.func_199560_c())) || recipe.func_77571_b().func_190926_b());
            player.func_195065_a(recipes);
            if (forceLimitedCrafting) {
                ((GameRules.BooleanValue)player.field_70170_p.func_82736_K().func_223585_a(GameRules.field_223618_u)).func_223570_a(true, server);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        Screen gui = event.getGui();
        if (disableRecipeBook && gui instanceof IRecipeShownListener) {
            Minecraft.func_71410_x().field_71439_g.func_199507_B().func_192813_a(false);
            List widgets = event.getWidgetList();
            for (Widget w : widgets) {
                if (!(w instanceof ImageButton)) continue;
                event.removeWidget(w);
                return;
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71439_g.field_70173_aa < 20) {
            ToastGui toasts = mc.func_193033_an();
            Deque toastQueue = toasts.field_191792_h;
            for (IToast toast : toastQueue) {
                if (!(toast instanceof RecipeToast)) continue;
                RecipeToast recipeToast = (RecipeToast)toast;
                List stacks = recipeToast.field_202906_c;
                if (stacks.size() <= 100) continue;
                toastQueue.remove(toast);
                return;
            }
        }
    }
}

