/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.module;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class HoeHarvestingModule
extends Module {
    @Config
    public static boolean hoesCanHaveFortune = true;

    public static int getRange(ItemStack hoe) {
        if (hoe.func_190926_b() || !(hoe.func_77973_b() instanceof HoeItem)) {
            return 1;
        }
        if (hoe.func_77973_b() == Items.field_151012_L || hoe.func_77973_b() == Items.field_234758_kU_) {
            return 3;
        }
        return 2;
    }

    public static boolean canFortuneApply(Enchantment enchantment, ItemStack stack) {
        return enchantment == Enchantments.field_185308_t && hoesCanHaveFortune && !stack.func_190926_b() && stack.func_77973_b() instanceof HoeItem;
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        IWorld world = event.getWorld();
        if (!(world instanceof World)) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        BlockPos basePos = event.getPos();
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof HoeItem && this.canHarvest(player, world, basePos, event.getState())) {
            int range = HoeHarvestingModule.getRange(stack);
            for (int i = 1 - range; i < range; ++i) {
                for (int k = 1 - range; k < range; ++k) {
                    BlockState state;
                    BlockPos pos;
                    if (i == 0 && k == 0 || !this.canHarvest(player, world, pos = basePos.func_177982_a(i, 0, k), state = world.func_180495_p(pos))) continue;
                    Block block = state.func_177230_c();
                    if (block.canHarvestBlock(state, (IBlockReader)world, pos, player)) {
                        block.func_180657_a((World)world, player, pos, state, world.func_175625_s(pos), stack);
                    }
                    world.func_175655_b(pos, false);
                    world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
                }
            }
            MiscUtil.damageStack(player, Hand.MAIN_HAND, stack, 1);
        }
    }

    private boolean canHarvest(PlayerEntity player, IWorld world, BlockPos pos, BlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof IPlantable) {
            IPlantable plant = (IPlantable)block;
            PlantType type = plant.getPlantType((IBlockReader)world, pos);
            return type != PlantType.WATER && type != PlantType.DESERT;
        }
        return state.func_185904_a() == Material.field_151585_k && state.func_196953_a(new BlockItemUseContext(new ItemUseContext(player, Hand.MAIN_HAND, new BlockRayTraceResult(new Vector3d(0.5, 0.5, 0.5), Direction.DOWN, pos, false))));
    }
}

