/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.module;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.SpamlessChatMessage;
import vazkii.quark.base.network.message.UpdateAfkMessage;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class ImprovedSleepingModule
extends Module {
    private int timeSinceKeystroke;
    private static List<String> sleepingPlayers = new ArrayList<String>();
    @Config
    public static boolean enableAfk = true;
    @Config
    @Config.Min(value=0.0, exclusive=true)
    public static int afkTime = 2400;
    @Config
    @Config.Min(value=0.0, exclusive=true)
    @Config.Max(value=1.0)
    public static double percentReq = 1.0;
    private static final String TAG_JUST_SLEPT = "quark:slept";
    private static final String TAG_AFK = "quark:afk";
    private static final int AFK_MSG = "quark afk".hashCode();
    private static final int SLEEP_MSG = "quark sleep".hashCode();

    public static void updateAfk(PlayerEntity player, boolean afk) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(ImprovedSleepingModule.class) || !enableAfk) {
            return;
        }
        if (player.field_70170_p.func_217369_A().size() != 1) {
            if (afk) {
                player.getPersistentData().func_74757_a(TAG_AFK, true);
                TranslationTextComponent text = new TranslationTextComponent("quark.misc.now_afk");
                text.func_240701_a_(new TextFormatting[]{TextFormatting.AQUA});
                SpamlessChatMessage.sendToPlayer(player, AFK_MSG, (ITextComponent)text);
            } else {
                player.getPersistentData().func_74757_a(TAG_AFK, false);
                TranslationTextComponent text = new TranslationTextComponent("quark.misc.left_afk");
                text.func_240701_a_(new TextFormatting[]{TextFormatting.AQUA});
                SpamlessChatMessage.sendToPlayer(player, AFK_MSG, (ITextComponent)text);
            }
        }
    }

    public static boolean isEveryoneAsleep(boolean parent) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(ImprovedSleepingModule.class)) {
            return parent;
        }
        return false;
    }

    public static boolean isEveryoneAsleep(World world) {
        Pair<Integer, Integer> counts = ImprovedSleepingModule.getPlayerCounts(world);
        int legitPlayers = (Integer)counts.getLeft();
        int sleepingPlayers = (Integer)counts.getRight();
        int reqPlayers = Math.max(1, (int)(percentReq * (double)legitPlayers));
        return legitPlayers > 0 && (float)sleepingPlayers / (float)reqPlayers >= 1.0f;
    }

    public static void whenNightPasses(ServerWorld world) {
        MinecraftServer server = world.func_73046_m();
        if (world.func_217369_A().size() == 1) {
            return;
        }
        boolean isDay = world.func_175657_ab() < 4;
        int msgCount = 10;
        int msg = world.field_73012_v.nextInt(msgCount);
        TranslationTextComponent message = new TranslationTextComponent(world.func_82736_K().func_223586_b(GameRules.field_223607_j) ? (isDay ? "quark.misc.day_has_passed" : "quark.misc.night_has_passed" + msg) : (isDay ? "quark.misc.day_no_passage" : "quark.misc.night_no_passage"));
        message.func_230530_a_(message.func_150256_b().func_240712_a_(TextFormatting.GOLD));
        for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
            SpamlessChatMessage.sendToPlayer((PlayerEntity)player, SLEEP_MSG, (ITextComponent)message);
        }
    }

    private static boolean doesPlayerCountForSleeping(PlayerEntity player) {
        return !player.func_175149_v() && !player.getPersistentData().func_74767_n(TAG_AFK);
    }

    private static boolean isPlayerSleeping(PlayerEntity player) {
        return player.func_71026_bH();
    }

    private static Pair<Integer, Integer> getPlayerCounts(World world) {
        int legitPlayers = 0;
        int sleepingPlayers = 0;
        for (PlayerEntity player : world.func_217369_A()) {
            if (!ImprovedSleepingModule.doesPlayerCountForSleeping(player)) continue;
            ++legitPlayers;
            if (!ImprovedSleepingModule.isPlayerSleeping(player)) continue;
            ++sleepingPlayers;
        }
        return Pair.of((Object)legitPlayers, (Object)sleepingPlayers);
    }

    @SubscribeEvent
    public void onWakeUp(PlayerWakeUpEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!event.updateWorld() && !event.wakeImmediately()) {
            player.getPersistentData().func_74772_a(TAG_JUST_SLEPT, player.field_70170_p.func_82737_E());
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        MinecraftServer server = world.func_73046_m();
        if (event.side == LogicalSide.CLIENT || world.func_234922_V_() != DimensionType.field_235999_c_ || event.phase != TickEvent.Phase.END || server == null) {
            return;
        }
        if (ImprovedSleepingModule.isEveryoneAsleep(world)) {
            if (world.func_82736_K().func_223586_b(GameRules.field_223607_j) && world instanceof ServerWorld) {
                long time = world.func_72820_D() + 24000L;
                ((ServerWorld)world).func_241114_a_(ForgeEventFactory.onSleepFinished((ServerWorld)((ServerWorld)world), (long)(time - time % 24000L), (long)world.func_72820_D()));
            }
            world.func_217369_A().stream().filter(LivingEntity::func_70608_bn).forEach(PlayerEntity::func_213366_dy);
            if (world.func_82736_K().func_223586_b(GameRules.field_223617_t)) {
                ((ServerWorld)world).func_73051_P();
            }
            if (world instanceof ServerWorld) {
                ImprovedSleepingModule.whenNightPasses((ServerWorld)world);
            }
            sleepingPlayers.clear();
            return;
        }
        ArrayList<String> sleepingPlayers = new ArrayList<String>();
        ArrayList<String> newSleepingPlayers = new ArrayList<String>();
        ArrayList<String> wasSleepingPlayers = new ArrayList<String>();
        ArrayList<String> nonSleepingPlayers = new ArrayList<String>();
        int legitPlayers = 0;
        for (PlayerEntity player : world.func_217369_A()) {
            if (!ImprovedSleepingModule.doesPlayerCountForSleeping(player)) continue;
            String name = player.func_146103_bH().getName();
            if (ImprovedSleepingModule.isPlayerSleeping(player)) {
                if (!ImprovedSleepingModule.sleepingPlayers.contains(name)) {
                    newSleepingPlayers.add(name);
                }
                sleepingPlayers.add(name);
            } else {
                if (ImprovedSleepingModule.sleepingPlayers.contains(name)) {
                    wasSleepingPlayers.add(name);
                }
                nonSleepingPlayers.add(name);
            }
            ++legitPlayers;
        }
        ImprovedSleepingModule.sleepingPlayers = sleepingPlayers;
        if (!(newSleepingPlayers.isEmpty() && wasSleepingPlayers.isEmpty() || world.func_217369_A().size() == 1)) {
            String newPlayer;
            boolean isDay = (double)world.func_72826_c(0.0f) < 0.5;
            int requiredPlayers = Math.max((int)Math.ceil((double)legitPlayers * percentReq), 0);
            StringTextComponent sibling = new StringTextComponent("(" + sleepingPlayers.size() + "/" + requiredPlayers + ")");
            StringTextComponent sleepingList = new StringTextComponent("");
            for (String s : sleepingPlayers) {
                sleepingList.func_230529_a_((ITextComponent)new StringTextComponent("\n\u2714 " + s).func_240701_a_(new TextFormatting[]{TextFormatting.GREEN}));
            }
            for (String s : nonSleepingPlayers) {
                sleepingList.func_230529_a_((ITextComponent)new StringTextComponent("\n\u2718 " + s).func_240701_a_(new TextFormatting[]{TextFormatting.RED}));
            }
            TranslationTextComponent hoverText = new TranslationTextComponent("quark.misc.sleeping_list_header", new Object[]{sleepingList});
            HoverEvent hover = new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)hoverText.func_230532_e_());
            sibling.func_240703_c_(sibling.func_150256_b().func_240716_a_(hover));
            sibling.func_150256_b().setUnderlined(Boolean.valueOf(true));
            String string = newPlayer = newSleepingPlayers.isEmpty() ? (String)wasSleepingPlayers.get(0) : (String)newSleepingPlayers.get(0);
            String translationKey = isDay ? (newSleepingPlayers.isEmpty() ? "quark.misc.person_not_napping" : "quark.misc.person_napping") : (newSleepingPlayers.isEmpty() ? "quark.misc.person_not_sleeping" : "quark.misc.person_sleeping");
            TranslationTextComponent message = new TranslationTextComponent(translationKey, new Object[]{newPlayer});
            message.func_240701_a_(new TextFormatting[]{TextFormatting.GOLD});
            message.func_240702_b_(" ");
            message.func_230529_a_((ITextComponent)sibling.func_230532_e_());
            for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
                SpamlessChatMessage.sendToPlayer((PlayerEntity)player, SLEEP_MSG, (ITextComponent)message);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerEntity lastPlayer;
        World logoutWorld = event.getPlayer().field_70170_p;
        List players = logoutWorld.func_217369_A();
        if (players.size() == 1 && (lastPlayer = (PlayerEntity)players.get(0)).getPersistentData().func_74767_n(TAG_AFK)) {
            lastPlayer.getPersistentData().func_74757_a(TAG_AFK, false);
            TranslationTextComponent text = new TranslationTextComponent("quark.misc.left_afk");
            text.func_240701_a_(new TextFormatting[]{TextFormatting.AQUA});
            if (lastPlayer instanceof ServerPlayerEntity) {
                SpamlessChatMessage.sendToPlayer(lastPlayer, AFK_MSG, (ITextComponent)text);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e != null) {
            ++this.timeSinceKeystroke;
            if (this.timeSinceKeystroke == afkTime) {
                QuarkNetwork.sendToServer(new UpdateAfkMessage(true));
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeystroke(InputEvent.KeyInputEvent event) {
        this.registerPress();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeystroke(GuiScreenEvent.KeyboardKeyEvent event) {
        this.registerPress();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerClick(PlayerInteractEvent event) {
        this.registerPress();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onMousePress(GuiScreenEvent.MouseInputEvent event) {
        this.registerPress();
    }

    private void registerPress() {
        if (this.timeSinceKeystroke >= afkTime && Minecraft.func_71410_x().field_71441_e != null) {
            QuarkNetwork.sendToServer(new UpdateAfkMessage(false));
        }
        this.timeSinceKeystroke = 0;
    }
}

