/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.module;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class ReplaceScaffoldingModule
extends Module {
    @Config(description="How many times the algorithm for finding out where a block would be placed is allowed to turn. If you set this to large values (> 3) it may start producing weird effects.")
    public int maxBounces = 1;

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        PlayerEntity player = event.getPlayer();
        if (state.func_177230_c() == Blocks.field_222420_lI && !player.func_226273_bm_()) {
            BlockPos last;
            ItemUseContext context;
            BlockItemUseContext bcontext;
            BlockState stateToPlace;
            BlockItem bitem;
            Block block;
            Direction dir = event.getFace();
            ItemStack stack = event.getItemStack();
            Hand hand = event.getHand();
            if (stack.func_77973_b() instanceof BlockItem && (block = (bitem = (BlockItem)stack.func_77973_b()).func_179223_d()) != Blocks.field_222420_lI && (stateToPlace = block.func_196258_a(bcontext = new BlockItemUseContext(context = new ItemUseContext(player, hand, new BlockRayTraceResult(new Vector3d(0.5, 1.0, 0.5), dir, last = this.getLastInLine(world, pos, dir), false))))) != null && stateToPlace.func_196955_c((IWorldReader)world, last)) {
                world.func_175656_a(last, stateToPlace);
                world.func_184133_a(player, last, stateToPlace.func_215695_r().func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                    ItemStack giveStack = new ItemStack((IItemProvider)Items.field_222011_iL);
                    if (!player.func_191521_c(giveStack)) {
                        player.func_71019_a(giveStack, false);
                    }
                }
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
        }
    }

    private BlockPos getLastInLine(World world, BlockPos start, Direction clickDir) {
        BlockPos result = this.getLastInLineOrNull(world, start, clickDir);
        if (result != null) {
            return result;
        }
        if (clickDir != Direction.UP && (result = this.getLastInLineOrNull(world, start, Direction.UP)) != null) {
            return result;
        }
        for (Direction horizontal : MiscUtil.HORIZONTALS) {
            if (horizontal == clickDir || (result = this.getLastInLineOrNull(world, start, horizontal)) == null) continue;
            return result;
        }
        if (clickDir != Direction.DOWN && (result = this.getLastInLineOrNull(world, start, Direction.DOWN)) != null) {
            return result;
        }
        return start;
    }

    private BlockPos getLastInLineOrNull(World world, BlockPos start, Direction dir) {
        BlockPos last = this.getLastInLineRecursive(world, start, dir, this.maxBounces);
        if (last.equals((Object)start)) {
            return null;
        }
        return last;
    }

    private BlockPos getLastInLineRecursive(World world, BlockPos start, Direction dir, int bouncesAllowed) {
        BlockState testState;
        BlockPos test;
        BlockPos curr = start;
        BlockState currState = world.func_180495_p(start);
        Block currBlock = currState.func_177230_c();
        while (world.func_195588_v(test = curr.func_177972_a(dir)) && (testState = world.func_180495_p(test)).func_177230_c() == currBlock) {
            curr = test;
        }
        if (!curr.equals((Object)start) && bouncesAllowed > 0) {
            BlockPos maxDist = null;
            double maxDistVal = -1.0;
            for (Direction dir2 : Direction.values()) {
                BlockPos testDist;
                double testDistVal;
                BlockPos bounceStart;
                if (dir.func_176740_k() == dir2.func_176740_k() || world.func_180495_p(bounceStart = curr.func_177972_a(dir2)).func_177230_c() != currBlock || !((testDistVal = (double)(testDist = this.getLastInLineRecursive(world, bounceStart, dir2, bouncesAllowed - 1)).func_218139_n((Vector3i)curr)) > maxDistVal)) continue;
                maxDist = testDist;
            }
            if (maxDist != null) {
                curr = maxDist;
            }
        }
        return curr;
    }
}

