/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.gen;

import java.util.Random;
import java.util.function.BooleanSupplier;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import vazkii.quark.base.world.generator.multichunk.ClusterBasedGenerator;
import vazkii.quark.world.config.BigStoneClusterConfig;
import vazkii.quark.world.module.BigStoneClustersModule;

public class BigStoneClusterGenerator
extends ClusterBasedGenerator {
    private final BigStoneClusterConfig config;
    private final BlockState placeState;

    public BigStoneClusterGenerator(BigStoneClusterConfig config, BlockState placeState, BooleanSupplier condition) {
        super(config.dimensions, () -> config.enabled && condition.getAsBoolean(), config, placeState.func_177230_c().getRegistryName().toString().hashCode());
        this.config = config;
        this.placeState = placeState;
    }

    @Override
    public boolean isSourceValid(WorldGenRegion world, ChunkGenerator generator, BlockPos pos) {
        return this.config.biomes.canSpawn(this.getBiome((IWorld)world, pos));
    }

    @Override
    public BlockPos[] getSourcesInChunk(WorldGenRegion world, Random random, ChunkGenerator generator, BlockPos chunkLeft) {
        BlockPos[] sources;
        int chance = this.config.rarity;
        if (chance > 0 && random.nextInt(chance) == 0) {
            BlockPos pos;
            sources = new BlockPos[1];
            int lower = Math.abs(this.config.minYLevel);
            int range = Math.abs(this.config.maxYLevel - this.config.minYLevel);
            sources[0] = pos = chunkLeft.func_177982_a(random.nextInt(16), random.nextInt(range) + lower, random.nextInt(16));
        } else {
            sources = new BlockPos[]{};
        }
        return sources;
    }

    public String toString() {
        return "BigStoneClusterGenerator[" + this.placeState + "]";
    }

    @Override
    public ClusterBasedGenerator.IGenerationContext createContext(BlockPos src, ChunkGenerator generator, Random random, BlockPos chunkCorner, WorldGenRegion world) {
        return pos -> {
            if (this.canPlaceBlock((IWorld)world, pos)) {
                world.func_180501_a(pos, this.placeState, 0);
            }
        };
    }

    private boolean canPlaceBlock(IWorld world, BlockPos pos) {
        return BigStoneClustersModule.blockReplacePredicate.test(world.func_180495_p(pos).func_177230_c());
    }
}

