/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.gen;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import vazkii.quark.base.world.config.ClusterSizeConfig;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.base.world.generator.multichunk.ClusterBasedGenerator;

public class UndergroundSpaceGenerator
extends ClusterBasedGenerator {
    public UndergroundSpaceGenerator(DimensionConfig dimConfig, ClusterSizeConfig sizeConfig, long seedXor) {
        super(dimConfig, sizeConfig, seedXor);
    }

    @Override
    public ClusterBasedGenerator.IGenerationContext createContext(BlockPos src, ChunkGenerator generator, Random random, BlockPos chunkCorner, WorldGenRegion world) {
        return pos -> {
            BlockState state = world.func_180495_p(pos);
            if (state.func_185887_b((IBlockReader)world, pos) > -1.0f) {
                if (pos.func_177956_o() < 6) {
                    world.func_180501_a(pos, Blocks.field_150353_l.func_176223_P(), 1);
                } else {
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        };
    }

    @Override
    public BlockPos[] getSourcesInChunk(WorldGenRegion world, Random random, ChunkGenerator generator, BlockPos chunkLeft) {
        int rarity;
        if (!(generator instanceof FlatChunkGenerator) && (rarity = this.shapeProvider.getRarity()) > 0 && random.nextInt(rarity) == 0) {
            BlockPos pos = chunkLeft.func_177982_a(random.nextInt(16), this.shapeProvider.getRandomYLevel(random), random.nextInt(16));
            if (this.shapeProvider.getBiomeTypes().canSpawn(this.getBiome((IWorld)world, pos))) {
                return new BlockPos[]{pos};
            }
        }
        return new BlockPos[0];
    }
}

