/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.module;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.world.config.BiomeTypeConfig;
import vazkii.quark.world.gen.structure.BigDungeonStructure;

@LoadModule(category=ModuleCategory.WORLD)
public class BigDungeonModule
extends Module {
    @Config(description="The chance that a big dungeon spawn candidate will be allowed to spawn. 0.2 is 20%, which is the same as the Pillager Outpost.")
    public static double spawnChance = 0.1;
    @Config
    public static String lootTable = "minecraft:chests/simple_dungeon";
    @Config
    public static int maxRooms = 10;
    @Config
    public static double chestChance = 0.5;
    @Config
    public static BiomeTypeConfig biomeTypes = new BiomeTypeConfig(true, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END);
    public static final BigDungeonStructure STRUCTURE = new BigDungeonStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);

    @Override
    public void construct() {
        RegistryHelper.register((IForgeRegistryEntry)STRUCTURE);
        Structure.field_236365_a_.put((Object)"quark:big_dungeon", (Object)STRUCTURE);
    }

    @Override
    public void setup() {
        STRUCTURE.setup();
        StructureSeparationSettings settings = new StructureSeparationSettings(20, 11, 79234823);
        ImmutableSet.of((Object)DimensionSettings.Preset.field_236122_b_, (Object)DimensionSettings.Preset.field_236123_c_, (Object)DimensionSettings.Preset.field_236124_d_, (Object)DimensionSettings.Preset.field_236125_e_, (Object)DimensionSettings.Preset.field_236126_f_, (Object)DimensionSettings.Preset.field_236127_g_, (Object[])new DimensionSettings.Preset[0]).forEach(p -> p.func_236137_b_().func_236108_a_().func_236195_a_().put(STRUCTURE, settings));
        StructureFeature structure = STRUCTURE.func_236391_a_((IFeatureConfig)NoFeatureConfig.field_202429_e);
        if (this.enabled) {
            for (Biome b : ForgeRegistries.BIOMES.getValues()) {
                if (!biomeTypes.canSpawn(b)) continue;
                b.func_235063_a_(structure);
            }
        }
    }
}

