/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.module;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.block.QuarkPillarBlock;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.base.world.config.OrePocketConfig;
import vazkii.quark.base.world.generator.OreGenerator;
import vazkii.quark.world.block.BiotiteOreBlock;

@LoadModule(category=ModuleCategory.WORLD, hasSubscriptions=true)
public class BiotiteModule
extends Module {
    @Config
    public boolean generateNaturally = false;
    @Config
    public boolean generateOnDragonDeath = true;
    @Config
    public int clustersPerDragonTick = 16;
    @Config
    public int dragonTicksPerCluster = 1;
    @Config
    public static DimensionConfig dimensions = DimensionConfig.end(false);
    @Config
    public static OrePocketConfig oreSettings = new OrePocketConfig(1, 64, 14, 16);
    private OreGenerator oregen;

    @Override
    public void construct() {
        new QuarkItem("biotite", this, new Item.Properties().func_200916_a(ItemGroup.field_78035_l));
        BiotiteOreBlock biotite_ore = new BiotiteOreBlock(this);
        this.oregen = new OreGenerator(dimensions, oreSettings, biotite_ore.func_176223_P(), OreGenerator.ENDSTONE_MATCHER, () -> this.generateNaturally);
        WorldGenHandler.addGenerator(this, this.oregen, GenerationStage.Decoration.UNDERGROUND_ORES, 2);
        AbstractBlock.Properties props = AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151646_E).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200943_b(0.8f);
        VariantHandler.addSlabAndStairs(new QuarkBlock("biotite_block", this, ItemGroup.field_78030_b, props));
        VariantHandler.addSlabAndStairs(new QuarkBlock("smooth_biotite", this, ItemGroup.field_78030_b, props));
        new QuarkBlock("chiseled_biotite_block", this, ItemGroup.field_78030_b, props);
        new QuarkPillarBlock("biotite_pillar", this, ItemGroup.field_78030_b, props);
        new QuarkBlock("biotite_bricks", this, ItemGroup.field_78030_b, props);
    }

    @SubscribeEvent
    public void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        if (this.generateOnDragonDeath && event.getEntityLiving() instanceof EnderDragonEntity && !event.getEntity().func_130014_f_().field_72995_K) {
            EnderDragonEntity dragon = (EnderDragonEntity)event.getEntity();
            World world = dragon.func_130014_f_();
            if (dragon.field_70995_bG > 0 && dragon.field_70995_bG % this.dragonTicksPerCluster == 0) {
                Random rand = world.field_73012_v;
                BlockPos basePos = dragon.func_233580_cy_();
                basePos = new BlockPos(basePos.func_177958_n() - 128, 0, basePos.func_177952_p() - 128);
                for (int i = 0; i < this.clustersPerDragonTick; ++i) {
                    BlockPos pos = basePos.func_177982_a(rand.nextInt(256), rand.nextInt(64), rand.nextInt(256));
                    this.oregen.place((IWorld)world, rand, pos);
                }
            }
        }
    }
}

