/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.module.underground;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.BiomeDictionary;
import vazkii.quark.base.block.QuarkInheritedPaneBlock;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.world.block.CaveCrystalBlock;
import vazkii.quark.world.config.UndergroundBiomeConfig;
import vazkii.quark.world.gen.underground.CaveCrystalUndergroundBiome;
import vazkii.quark.world.gen.underground.UndergroundBiome;
import vazkii.quark.world.module.underground.UndergroundBiomeModule;

@LoadModule(category=ModuleCategory.WORLD)
public class CaveCrystalUndergroundBiomeModule
extends UndergroundBiomeModule {
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=1.0)
    public static double crystalSpawnChance = 0.025;
    @Config
    public static boolean crystalsGrowInLava = false;
    @Config(description="The chance that a crystal can grow, this is on average 1 in X world ticks, set to a higher value to make them grow slower. Minimum is 1, for every tick. Set to 0 to disable growth.")
    public static int caveCrystalGrowthChance = 5;
    @Config(flag="cave_crystal_runes")
    public static boolean crystalsCraftRunes = true;
    public static List<CaveCrystalBlock> crystals = Lists.newArrayList();
    public static ITag<Block> crystalTag;

    public static Block crystal(int floorIdx) {
        return (Block)crystals.get(MathHelper.func_76125_a((int)floorIdx, (int)0, (int)(crystals.size() - 1)));
    }

    @Override
    public void construct() {
        crystals.add(new CaveCrystalBlock("red_crystal", 0xFF0000, this, MaterialColor.field_151645_D));
        crystals.add(new CaveCrystalBlock("orange_crystal", 0xFF8000, this, MaterialColor.field_151676_q));
        crystals.add(new CaveCrystalBlock("yellow_crystal", 0xFFFF00, this, MaterialColor.field_151673_t));
        crystals.add(new CaveCrystalBlock("green_crystal", 65280, this, MaterialColor.field_151651_C));
        crystals.add(new CaveCrystalBlock("blue_crystal", 65535, this, MaterialColor.field_151674_s));
        crystals.add(new CaveCrystalBlock("indigo_crystal", 255, this, MaterialColor.field_151649_A));
        crystals.add(new CaveCrystalBlock("violet_crystal", 0xFF00FF, this, MaterialColor.field_151675_r));
        crystals.add(new CaveCrystalBlock("white_crystal", 0xFFFFFF, this, MaterialColor.field_151666_j));
        crystals.add(new CaveCrystalBlock("black_crystal", 0, this, MaterialColor.field_151646_E));
        for (CaveCrystalBlock block : crystals) {
            new QuarkInheritedPaneBlock(block);
        }
        super.construct();
    }

    @Override
    public void setup() {
        super.setup();
        crystalTag = BlockTags.func_199894_a((String)"quark:crystal");
    }

    @Override
    protected String getBiomeName() {
        return "crystal";
    }

    @Override
    protected UndergroundBiomeConfig getBiomeConfig() {
        return new UndergroundBiomeConfig((UndergroundBiome)new CaveCrystalUndergroundBiome(), 400, true, BiomeDictionary.Type.OCEAN).setDefaultSize(42, 18, 22, 8);
    }
}

