/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.api;

import com.ewyboy.quickharvest.api.IHarvester;
import com.ewyboy.quickharvest.harvester.ChorusHarvester;
import com.ewyboy.quickharvest.harvester.DefaultHarvester;
import com.ewyboy.quickharvest.harvester.HugeMushroomHarvester;
import com.ewyboy.quickharvest.harvester.KelpHarvester;
import com.ewyboy.quickharvest.harvester.StemPlantHarvester;
import com.ewyboy.quickharvest.harvester.TallPlantHarvester;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.BeetrootBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarrotBlock;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.PotatoBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class HarvestManager {
    private static final Map<BlockPredicate, IHarvester> HARVEST_HANDLER_MAP = new HashMap<BlockPredicate, IHarvester>();

    public static void onBlockQuickHarvest(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        if (player.func_70093_af()) {
            return;
        }
        if (event.getUseBlock() != Event.Result.DENY && event.getUseItem() != Event.Result.DENY && world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            BlockPos pos = event.getPos();
            BlockState state = event.getWorld().func_180495_p(pos);
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            Hand hand = event.getHand();
            HarvestManager.getHarvesterFor(state).filter(harvester -> harvester.canHarvest(serverPlayer, hand, serverWorld, pos, state)).ifPresent(harvester -> {
                harvester.harvest(serverPlayer, hand, serverWorld, pos, state);
                event.setUseBlock(Event.Result.DENY);
                event.setUseItem(Event.Result.DENY);
                event.setCanceled(true);
            });
        }
    }

    public static void register(IHarvester handler, Block ... validBlocks) {
        HARVEST_HANDLER_MAP.put(new BlockPredicate(validBlocks), handler);
    }

    private static Optional<IHarvester> getHarvesterFor(BlockState state) {
        return HarvestManager.getHarvesterFor(state.func_177230_c());
    }

    private static Optional<IHarvester> getHarvesterFor(Block block) {
        return HARVEST_HANDLER_MAP.keySet().stream().filter(predicate -> predicate.test(block)).map(HARVEST_HANDLER_MAP::get).findFirst();
    }

    static {
        HarvestManager.register(new DefaultHarvester(Items.field_151014_N, Blocks.field_150464_aj.func_176223_P(), CropsBlock.field_176488_a), Blocks.field_150464_aj);
        HarvestManager.register(new DefaultHarvester(Items.field_151172_bF, Blocks.field_150459_bM.func_176223_P(), CarrotBlock.field_176488_a), Blocks.field_150459_bM);
        HarvestManager.register(new DefaultHarvester(Items.field_151174_bG, Blocks.field_150469_bN.func_176223_P(), PotatoBlock.field_176488_a), Blocks.field_150469_bN);
        HarvestManager.register(new DefaultHarvester(Items.field_185163_cU, Blocks.field_185773_cZ.func_176223_P(), BeetrootBlock.field_185531_a), Blocks.field_185773_cZ);
        HarvestManager.register(new DefaultHarvester(Items.field_151075_bm, Blocks.field_150388_bm.func_176223_P(), NetherWartBlock.field_176486_a), Blocks.field_150388_bm);
        HarvestManager.register(new DefaultHarvester(Items.field_196130_bo, Blocks.field_150375_by.func_176223_P(), CocoaBlock.field_176501_a), Blocks.field_150375_by);
        HarvestManager.register(new StemPlantHarvester(), Blocks.field_196713_dt, Blocks.field_150440_ba);
        HarvestManager.register(new StemPlantHarvester(), Blocks.field_196711_ds, Blocks.field_150423_aK);
        HarvestManager.register(new TallPlantHarvester(), Blocks.field_196608_cF, Blocks.field_150434_aF);
        HarvestManager.register(new ChorusHarvester(), Blocks.field_185766_cS, Blocks.field_185765_cR);
        HarvestManager.register(new HugeMushroomHarvester(), Blocks.field_150420_aW, Blocks.field_150419_aX, Blocks.field_196706_do);
        HarvestManager.register(new KelpHarvester(), Blocks.field_203214_jx, Blocks.field_203215_jy);
    }

    private static class BlockPredicate
    implements Predicate<Block> {
        private final Block[] blocks;

        BlockPredicate(Block ... blocks) {
            this.blocks = blocks;
        }

        @Override
        public boolean test(Block block) {
            return Arrays.stream(this.blocks).anyMatch(Predicate.isEqual(block));
        }
    }
}

