/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.harvester;

import com.ewyboy.quickharvest.QuickHarvest;
import com.ewyboy.quickharvest.api.HarvesterImpl;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.BlockState;
import net.minecraft.block.CocoaBlock;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class DefaultHarvester
extends HarvesterImpl {
    private final IntegerProperty ageProperty;
    private final int maxAge;

    public DefaultHarvester(Item replantItem, BlockState replantState, IntegerProperty ageProperty) {
        super(QuickHarvest.HOE_TAG, new ItemStack((IItemProvider)replantItem), replantState);
        this.ageProperty = ageProperty;
        this.maxAge = ageProperty.func_177700_c().stream().mapToInt(Integer::intValue).max().getAsInt();
    }

    @Override
    public boolean canHarvest(ServerPlayerEntity player, Hand hand, ServerWorld world, BlockPos pos, BlockState state) {
        return super.canHarvest(player, hand, world, pos, state) && state.func_196959_b((IProperty)this.ageProperty) && (Integer)state.func_177229_b((IProperty)this.ageProperty) == this.maxAge;
    }

    @Override
    public void harvest(ServerPlayerEntity player, Hand hand, ServerWorld world, BlockPos pos, BlockState state) {
        if (!this.canHarvest(player, hand, world, pos, state)) {
            return;
        }
        NonNullList drops = NonNullList.func_191196_a();
        if (this.breakBlock(player, world, pos, (NonNullList<ItemStack>)drops)) {
            System.out.println(drops);
            if (state.func_196959_b((IProperty)BlockStateProperties.field_208157_J)) {
                this.replant(player, world, pos, (NonNullList<ItemStack>)drops, ImmutableMap.of((Object)CocoaBlock.field_185512_D, (Object)state.func_177229_b((IProperty)CocoaBlock.field_185512_D)));
            } else {
                this.replant(player, world, pos, (NonNullList<ItemStack>)drops);
            }
            System.out.println(drops);
        }
        drops.forEach(drop -> this.giveItemToPlayer(player, (ItemStack)drop));
    }
}

