/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.harvester;

import com.ewyboy.quickharvest.api.HarvesterImpl;
import com.ewyboy.quickharvest.util.FloodFill;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.KelpBlock;
import net.minecraft.block.KelpTopBlock;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class KelpHarvester
extends HarvesterImpl {
    private static final Predicate<BlockState> IS_KELP_BLOCK = s -> s.func_177230_c() instanceof KelpBlock;
    private static final Predicate<BlockState> IS_KELP_TOP = s -> s.func_177230_c() instanceof KelpTopBlock;
    private static final Predicate<BlockState> IS_KELP = IS_KELP_BLOCK.or(IS_KELP_TOP);

    @Override
    public void harvest(ServerPlayerEntity player, Hand hand, ServerWorld world, BlockPos pos, BlockState state) {
        FloodFill floodFill = new FloodFill(pos, s -> {
            Direction[] directionArray;
            if (IS_KELP.test((BlockState)s)) {
                Direction[] directionArray2 = new Direction[2];
                directionArray2[0] = Direction.UP;
                directionArray = directionArray2;
                directionArray2[1] = Direction.DOWN;
            } else {
                directionArray = NO_DIRECTIONS;
            }
            return directionArray;
        }, (Set<Predicate<BlockState>>)ImmutableSet.of(IS_KELP));
        floodFill.search(world);
        NonNullList drops = NonNullList.func_191196_a();
        floodFill.getFoundTargets().get(IS_KELP).stream().filter(info -> !info.func_177508_d().equals((Object)floodFill.getLowestPoint())).sorted(Comparator.comparingInt(i -> i.func_177508_d().func_177956_o()).reversed()).forEachOrdered(info -> this.breakBlock(player, world, info.func_177508_d(), (NonNullList<ItemStack>)drops));
        drops.forEach(drop -> this.giveItemToPlayer(player, (ItemStack)drop));
    }
}

