/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.util;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;

public class FloodFill {
    private final Function<BlockState, Iterable<Direction>> stateSearchMapper;
    private final Map<Predicate<BlockState>, Set<CachedBlockInfo>> foundTargets;
    private final Deque<BlockPos> toVisit;
    private final Set<BlockPos> visited;
    private BlockPos lowestPoint;
    private BlockPos highestPoint;

    public FloodFill(BlockPos origin, Function<BlockState, Direction[]> stateSearchMapper, Set<Predicate<BlockState>> targets) {
        this.lowestPoint = origin;
        this.highestPoint = origin;
        this.stateSearchMapper = s -> Arrays.asList((Object[])stateSearchMapper.apply((BlockState)s));
        this.foundTargets = new HashMap<Predicate<BlockState>, Set<CachedBlockInfo>>();
        targets.forEach(target -> {
            Set cfr_ignored_0 = this.foundTargets.put((Predicate<BlockState>)target, new HashSet());
        });
        this.visited = new HashSet<BlockPos>();
        this.toVisit = new ArrayDeque<BlockPos>(){

            @Override
            public void push(BlockPos pos) {
                if (FloodFill.this.visited.add(pos)) {
                    super.push(pos);
                }
            }
        };
        this.toVisit.push(origin);
    }

    public void search(ServerWorld world) {
        while (!this.toVisit.isEmpty()) {
            BlockPos pos = this.toVisit.pollLast();
            CachedBlockInfo blockInfo = new CachedBlockInfo((IWorldReader)world, pos, false);
            BlockState blockState = blockInfo.func_177509_a();
            if (blockState == null) continue;
            this.stateSearchMapper.apply(blockState).forEach(offset -> this.toVisit.push(pos.func_177972_a(offset)));
            this.foundTargets.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(blockState)).forEach(entry -> ((Set)entry.getValue()).add(blockInfo));
            if (!this.foundTargets.keySet().stream().anyMatch(test -> test.test(blockState))) continue;
            if (pos.func_177956_o() < this.lowestPoint.func_177956_o()) {
                this.lowestPoint = pos;
                continue;
            }
            if (pos.func_177956_o() <= this.highestPoint.func_177956_o()) continue;
            this.highestPoint = pos;
        }
    }

    public Map<Predicate<BlockState>, Set<CachedBlockInfo>> getFoundTargets() {
        return this.foundTargets;
    }

    public BlockPos getLowestPoint() {
        return this.lowestPoint;
    }

    public BlockPos getHighestPoint() {
        return this.highestPoint;
    }

    public FloodFill add(FloodFill other) {
        if (other.highestPoint.func_177956_o() > this.highestPoint.func_177956_o()) {
            this.highestPoint = other.highestPoint;
        }
        if (other.lowestPoint.func_177956_o() < this.lowestPoint.func_177956_o()) {
            this.lowestPoint = other.lowestPoint;
        }
        this.visited.addAll(other.visited);
        other.getFoundTargets().forEach((key, value) -> this.foundTargets.computeIfAbsent((Predicate<BlockState>)key, $ -> new HashSet()).addAll(value));
        return this;
    }
}

