/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.api;

import com.ewyboy.quickharvest.api.IHarvester;
import com.ewyboy.quickharvest.config.Config;
import java.util.Collection;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class HarvesterImpl
implements IHarvester {
    public static final String HARVEST_ERROR_PROTECTED_KEY = "quickharvest.message.error.protected";
    protected static final Direction[] NO_DIRECTIONS = new Direction[0];
    private final ITag.INamedTag<Item> validTool;
    private final Supplier<ItemStack> replant;
    private final Supplier<BlockState> replantState;
    protected final BooleanSupplier isReplantable;
    private ForgeConfigSpec.BooleanValue enabled;

    public abstract String getName();

    public HarvesterImpl() {
        this(null, null);
    }

    public HarvesterImpl(ITag.INamedTag<Item> validTool) {
        this(validTool, null);
    }

    public HarvesterImpl(ITag.INamedTag<Item> validTool, Supplier<BlockState> replantState) {
        this(validTool, () -> ItemStack.field_190927_a, replantState);
    }

    public HarvesterImpl(ITag.INamedTag<Item> validTool, Supplier<ItemStack> replant, Supplier<BlockState> replantState) {
        this.validTool = validTool;
        this.replant = replant;
        this.replantState = replantState;
        this.isReplantable = () -> !((ItemStack)replant.get()).func_190926_b();
    }

    public boolean isBlockModifiable(PlayerEntity player, ServerWorld world, BlockPos pos) {
        return world.func_175667_e(pos) && world.func_175660_a(player, pos);
    }

    public boolean holdingValidTool(ServerPlayerEntity playerEntity) {
        if (Config.SETTINGS.requiresTool()) {
            ItemStack heldItem = playerEntity.func_184586_b(Hand.MAIN_HAND);
            return this.validTool != null && this.validTool.func_230235_a_((Object)heldItem.func_77973_b());
        }
        return true;
    }

    public boolean breakBlock(ServerPlayerEntity playerEntity, ServerWorld world, BlockPos pos, NonNullList<ItemStack> drops) {
        if (this.holdingValidTool(playerEntity) && this.isBlockModifiable((PlayerEntity)playerEntity, world, pos)) {
            BlockState blockState = world.func_180495_p(pos);
            TileEntity tileEntity = world.func_175625_s(pos);
            ItemStack heldItem = playerEntity.func_184586_b(Hand.MAIN_HAND);
            drops.addAll((Collection)Block.func_220077_a((BlockState)blockState, (ServerWorld)world, (BlockPos)pos, (TileEntity)tileEntity, (Entity)playerEntity, (ItemStack)heldItem));
            world.func_175655_b(pos, false);
            this.damageTool(playerEntity, heldItem, 1);
            return true;
        }
        return false;
    }

    public ItemStack takeReplantable(NonNullList<ItemStack> drops) {
        ItemStack replant = this.replant.get();
        for (ItemStack stack : drops) {
            if (!stack.func_77969_a(replant) || stack.func_190916_E() < replant.func_190916_E()) continue;
            stack.func_190918_g(replant.func_190916_E());
            return replant.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public boolean replant(ServerPlayerEntity player, ServerWorld world, BlockPos pos, NonNullList<ItemStack> drops) {
        return this.replant(player, world, pos, drops, null);
    }

    public <T extends Comparable<T>> boolean replant(ServerPlayerEntity player, ServerWorld world, BlockPos pos, NonNullList<ItemStack> drops, Map<Property<T>, T> stateMapper) {
        ItemStack itemStack;
        if (!this.isReplantable.getAsBoolean() || this.replantState == null) {
            return true;
        }
        if (this.holdingValidTool(player) && !(itemStack = this.takeReplantable(drops)).func_190926_b()) {
            BlockState state = this.replantState.get();
            if (stateMapper != null) {
                for (Map.Entry<Property<T>, T> entry : stateMapper.entrySet()) {
                    state = (BlockState)state.func_206870_a(entry.getKey(), (Comparable)entry.getValue());
                }
            }
            world.func_175656_a(pos, state);
            return true;
        }
        return false;
    }

    public void dropStackAt(ServerPlayerEntity playerEntity, ServerWorld world, BlockPos pos, ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        itemEntity.func_213293_j(0.0, 0.0, 0.0);
        itemEntity.func_200217_b(playerEntity.func_110124_au());
        itemEntity.func_174868_q();
        world.func_217376_c((Entity)itemEntity);
    }

    public void giveItemToPlayer(ServerPlayerEntity playerEntity, ItemStack stack) {
        if (!playerEntity.func_191521_c(stack)) {
            playerEntity.func_71019_a(stack, false);
        }
    }

    public void tellPlayerNo(PlayerEntity player, String messageKey) {
        player.func_146105_b((ITextComponent)new TranslationTextComponent(messageKey), true);
    }

    public void setEnabled(ForgeConfigSpec.BooleanValue enabled) {
        this.enabled = enabled;
    }

    @Override
    public BooleanSupplier enabled() {
        return () -> ((ForgeConfigSpec.BooleanValue)this.enabled).get();
    }

    public boolean damageTool(ServerPlayerEntity player, ItemStack tool, int amount) {
        if (!Config.SETTINGS.damagesTool()) {
            return true;
        }
        if (tool.func_77958_k() - tool.func_77952_i() >= amount) {
            tool.func_222118_a(amount, (LivingEntity)player, p -> p.func_213334_d(Hand.MAIN_HAND));
            return true;
        }
        return false;
    }

    @Override
    public boolean canHarvest(ServerPlayerEntity player, Hand hand, ServerWorld world, BlockPos pos, BlockState state) {
        return this.holdingValidTool(player) && this.isBlockModifiable((PlayerEntity)player, world, pos);
    }
}

