/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.harvester;

import com.ewyboy.quickharvest.api.HarvesterImpl;
import com.ewyboy.quickharvest.util.FloodFill;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChorusFlowerBlock;
import net.minecraft.block.ChorusPlantBlock;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class ChorusHarvester
extends HarvesterImpl {
    private static final Predicate<BlockState> fruit = s -> s.func_177230_c() instanceof ChorusFlowerBlock;
    private static final Predicate<BlockState> notFruit = s -> s.func_177230_c() instanceof ChorusPlantBlock;

    public ChorusHarvester() {
        super(null, () -> new ItemStack((IItemProvider)Items.field_221663_bT), () -> Blocks.field_185766_cS.func_176223_P());
    }

    @Override
    public String getName() {
        return "Chorus";
    }

    @Override
    public void harvest(ServerPlayerEntity player, Hand hand, ServerWorld world, BlockPos pos, BlockState state) {
        FloodFill floodFill = new FloodFill(pos, s -> fruit.or(notFruit).test((BlockState)s) ? Direction.values() : NO_DIRECTIONS, (Set<Predicate<BlockState>>)ImmutableSet.of(fruit, notFruit));
        floodFill.search(world);
        NonNullList drops = NonNullList.func_191196_a();
        if (floodFill.getFoundTargets().get(fruit).stream().allMatch(info -> this.breakBlock(player, world, info.func_177508_d(), (NonNullList<ItemStack>)drops))) {
            floodFill.getFoundTargets().get(notFruit).forEach(info -> this.breakBlock(player, world, info.func_177508_d(), (NonNullList<ItemStack>)drops));
            this.replant(player, world, floodFill.getLowestPoint(), (NonNullList<ItemStack>)drops);
        }
        drops.forEach(drop -> this.giveItemToPlayer(player, (ItemStack)drop));
    }
}

