/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.harvester;

import com.ewyboy.quickharvest.QuickHarvest;
import com.ewyboy.quickharvest.api.HarvesterImpl;
import com.ewyboy.quickharvest.util.FloodFill;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;

public class HugeMushroomHarvester
extends HarvesterImpl {
    private static final Predicate<BlockState> IS_BROWN_MUSHROOM = s -> s.func_177230_c() == Blocks.field_150420_aW;
    private static final Predicate<BlockState> IS_RED_MUSHROOM = s -> s.func_177230_c() == Blocks.field_150419_aX;
    private static final Predicate<BlockState> IS_MUSHROOM_STEM = s -> s.func_177230_c() == Blocks.field_196706_do;
    private static final Predicate<BlockState> IS_MUSHROOM = IS_BROWN_MUSHROOM.or(IS_RED_MUSHROOM).or(IS_MUSHROOM_STEM);

    public HugeMushroomHarvester() {
        super(QuickHarvest.AXE_TAG);
    }

    @Override
    public String getName() {
        return "Huge Mushroom";
    }

    @Override
    public boolean canHarvest(ServerPlayerEntity player, Hand hand, ServerWorld world, BlockPos pos, BlockState state) {
        return super.canHarvest(player, hand, world, pos, state) && world.func_180495_p(pos.func_177977_b()).canSustainPlant((IBlockReader)world, pos, Direction.UP, (IPlantable)Blocks.field_150337_Q) && IS_MUSHROOM_STEM.test(state);
    }

    @Override
    public void harvest(ServerPlayerEntity player, Hand hand, ServerWorld world, BlockPos pos, BlockState state) {
        FloodFill floodFill = new FloodFill(pos, s -> IS_MUSHROOM.test((BlockState)s) ? (Direction[])Arrays.stream(Direction.values()).filter(off -> (Boolean)s.func_177229_b((Property)SixWayBlock.field_196491_B.get(off)) == false).toArray(Direction[]::new) : NO_DIRECTIONS, (Set<Predicate<BlockState>>)ImmutableSet.of(IS_MUSHROOM, IS_RED_MUSHROOM));
        floodFill.search(world);
        if (!floodFill.getFoundTargets().get(IS_RED_MUSHROOM).isEmpty()) {
            for (Direction horizOff : Direction.Plane.HORIZONTAL) {
                BlockPos offset = floodFill.getLowestPoint().func_177967_a(horizOff, 2).func_177984_a();
                BlockState offsetState = world.func_180495_p(offset);
                while (!(offsetState.func_177230_c() instanceof HugeMushroomBlock) && offset.func_177956_o() < floodFill.getLowestPoint().func_177956_o() + 10) {
                    offset = offset.func_177984_a();
                    offsetState = world.func_180495_p(offset);
                }
                if (!IS_MUSHROOM_STEM.test(state)) continue;
                FloodFill newFill = new FloodFill(offset, s -> IS_RED_MUSHROOM.test((BlockState)s) ? Direction.values() : NO_DIRECTIONS, (Set<Predicate<BlockState>>)ImmutableSet.of(IS_MUSHROOM));
                newFill.search(world);
                floodFill.add(newFill);
            }
        }
        NonNullList drops = NonNullList.func_191196_a();
        floodFill.getFoundTargets().get(IS_MUSHROOM).forEach(info -> this.breakBlock(player, world, info.func_177508_d(), (NonNullList<ItemStack>)drops));
        this.replant(player, world, floodFill.getLowestPoint(), (NonNullList<ItemStack>)drops);
        drops.forEach(drop -> this.giveItemToPlayer(player, (ItemStack)drop));
    }

    @Override
    public ItemStack takeReplantable(NonNullList<ItemStack> drops) {
        for (ItemStack stack : drops) {
            if (!Tags.Items.MUSHROOMS.func_230235_a_((Object)stack.func_77973_b()) || stack.func_190916_E() < 1) continue;
            ItemStack ret = stack.func_77946_l();
            stack.func_190918_g(1);
            ret.func_190920_e(1);
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean replant(ServerPlayerEntity player, ServerWorld world, BlockPos pos, NonNullList<ItemStack> drops) {
        ItemStack itemStack;
        if (this.holdingValidTool(player) && !(itemStack = this.takeReplantable(drops)).func_190926_b()) {
            world.func_175656_a(pos, ((BlockItem)itemStack.func_77973_b()).func_179223_d().func_176223_P());
            return true;
        }
        return false;
    }
}

