/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.harvester;

import com.ewyboy.quickharvest.api.HarvesterImpl;
import com.ewyboy.quickharvest.util.FloodFill;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class TallPlantHarvester
extends HarvesterImpl {
    @Override
    public String getName() {
        return "Tall Plant";
    }

    @Override
    public boolean canHarvest(ServerPlayerEntity player, Hand hand, ServerWorld world, BlockPos pos, BlockState state) {
        return super.canHarvest(player, hand, world, pos, state) && !player.func_184586_b(hand).func_77973_b().equals(state.func_177230_c().func_199767_j());
    }

    @Override
    public void harvest(ServerPlayerEntity player, Hand hand, ServerWorld world, BlockPos pos, BlockState state) {
        Predicate<BlockState> isSame = s -> s.func_177230_c() == state.func_177230_c();
        FloodFill floodFill = new FloodFill(pos, s -> {
            Direction[] directionArray;
            if (isSame.test((BlockState)s)) {
                Direction[] directionArray2 = new Direction[2];
                directionArray2[0] = Direction.UP;
                directionArray = directionArray2;
                directionArray2[1] = Direction.DOWN;
            } else {
                directionArray = NO_DIRECTIONS;
            }
            return directionArray;
        }, (Set<Predicate<BlockState>>)ImmutableSet.of(isSame));
        floodFill.search(world);
        NonNullList drops = NonNullList.func_191196_a();
        floodFill.getFoundTargets().get(isSame).stream().filter(info -> !info.func_177508_d().equals((Object)floodFill.getLowestPoint())).sorted(Comparator.comparingInt(i -> i.func_177508_d().func_177956_o()).reversed()).forEachOrdered(info -> this.breakBlock(player, world, info.func_177508_d(), (NonNullList<ItemStack>)drops));
        drops.forEach(drop -> this.giveItemToPlayer(player, (ItemStack)drop));
    }
}

