/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.config;

import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;

public class HarvesterConfig {
    private final ForgeConfigSpec.BooleanValue enabled;
    private final ForgeConfigSpec.BooleanValue requiresTool;
    private final ForgeConfigSpec.BooleanValue takeReplantItem;
    private final ForgeConfigSpec.ConfigValue<String> validToolType;
    private final ForgeConfigSpec.ConfigValue<String> replantItem;
    private final String name;

    public HarvesterConfig(String name, ForgeConfigSpec.Builder configBuilder, boolean enabled, boolean requiresTool, boolean takeReplantItem, ToolType toolType, String replantDefault) {
        this.name = name;
        configBuilder.push(name);
        this.enabled = configBuilder.comment("If true, this harvester will be enabled.").translation(String.format("config.%s.%s.enabled", "quickharvest", name)).worldRestart().define("enabled", enabled);
        this.requiresTool = configBuilder.comment("If true, this harvester will require the set tool to function.").translation(String.format("config.%s.%s.requires_tool", "quickharvest", name)).worldRestart().define("requires_tool", requiresTool);
        this.takeReplantItem = configBuilder.comment("If true, this harvester will take a replant item when performing a quick harvest.").translation(String.format("config.%s.%s.take_replant_item", "quickharvest", name)).worldRestart().define("take_replant_item", takeReplantItem);
        this.validToolType = configBuilder.comment("A string representing the type of tool required to use the harvester.").comment("NOTE: Only works if 'require_tool' is set to true").comment("Recommended values: 'hoe', 'axe', 'shovel', 'pickaxe'").translation(String.format("config.%s.%s.valid_tool_type", "quickharvest", name)).define("valid_tool_type", (Object)(toolType == null ? "" : toolType.getName()));
        this.replantItem = configBuilder.comment("The registry name of the item that is required to replant after a quick harvest.").comment("NOTE: This only works if 'take_replant_item' is true.").translation(String.format("config.%s.%s.replant_item", "quickharvest", name)).worldRestart().define("replant_item", (Object)replantDefault, str -> Objects.nonNull(str) && ResourceLocation.func_217855_b((String)((String)str)));
        configBuilder.pop();
    }

    public boolean isEnabled() {
        return (Boolean)this.enabled.get();
    }

    public boolean requiresTool() {
        return (Boolean)this.requiresTool.get();
    }

    public boolean takesReplantItem() {
        return (Boolean)this.takeReplantItem.get();
    }

    public ToolType getToolType() {
        String toolType = (String)this.validToolType.get();
        if (toolType.trim().isEmpty()) {
            return null;
        }
        return ToolType.get((String)toolType);
    }

    public Item getReplantItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)((String)this.replantItem.get())));
    }

    public String getName() {
        return this.name;
    }
}

