/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.harvester;

import com.ewyboy.quickharvest.api.Harvester;
import com.ewyboy.quickharvest.config.Config;
import com.ewyboy.quickharvest.config.HarvesterConfig;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public abstract class AbstractHarvester
extends Harvester {
    private final HarvesterConfig config;

    protected AbstractHarvester() {
        this(Config.DEFAULT);
    }

    protected AbstractHarvester(HarvesterConfig config) {
        this.config = config;
    }

    @Override
    public boolean canHarvest(PlayerEntity player, Hand hand, ServerWorld world, BlockPos pos, BlockState state, Direction side) {
        return this.isEffectiveOn(state) && this.canPlayerEdit(player, hand, world, pos, state, side) && (!this.requiresTool() || player.func_184614_ca().getToolTypes().contains(this.requiredTool()));
    }

    @Override
    public boolean canPlayerEdit(PlayerEntity player, Hand hand, ServerWorld world, BlockPos pos, BlockState state, Direction side) {
        return world.func_175667_e(pos) && world.func_175660_a(player, pos);
    }

    @Override
    public boolean enabled() {
        return this.config.isEnabled();
    }

    @Override
    public boolean requiresTool() {
        return this.config.requiresTool();
    }

    @Override
    public ToolType requiredTool() {
        return this.config.getToolType();
    }

    @Override
    protected boolean takesReplantItem() {
        return this.config.takesReplantItem();
    }

    @Override
    public Predicate<ItemStack> replantItem() {
        return stack -> stack.func_77973_b() == this.config.getReplantItem();
    }

    protected void damageTool(PlayerEntity playerEntity, Hand hand, int amount) {
        if (!this.requiresTool()) {
            return;
        }
        playerEntity.func_184586_b(hand).func_222118_a(amount, (LivingEntity)playerEntity, it -> it.func_213334_d(hand));
    }

    protected void takeReplantItem(List<ItemStack> drops) {
        if (!this.takesReplantItem()) {
            return;
        }
        Predicate<ItemStack> replantPredicate = this.replantItem();
        for (ItemStack drop : drops) {
            if (!replantPredicate.test(drop)) continue;
            drop.func_190918_g(1);
            return;
        }
    }
}

