/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.harvester;

import com.ewyboy.quickharvest.config.HarvesterConfig;
import com.ewyboy.quickharvest.harvester.AbstractHarvester;
import com.ewyboy.quickharvest.util.FloodFill;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChorusFlowerBlock;
import net.minecraft.block.ChorusPlantBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class ChorusHarvester
extends AbstractHarvester {
    private static final Predicate<BlockState> fruit = s -> s.func_177230_c() instanceof ChorusFlowerBlock;
    private static final Predicate<BlockState> notFruit = s -> s.func_177230_c() instanceof ChorusPlantBlock;

    public ChorusHarvester(HarvesterConfig config) {
        super(config);
    }

    @Override
    public List<ItemStack> harvest(PlayerEntity player, Hand hand, ServerWorld world, BlockPos pos, BlockState state, Direction side) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        FloodFill floodFill = new FloodFill(pos, s -> fruit.or(notFruit).test((BlockState)s) ? Direction.values() : FloodFill.NO_DIRECTIONS, (Set<Predicate<BlockState>>)ImmutableSet.of(fruit, notFruit));
        int blocksBroken = 0;
        floodFill.search(world);
        for (Set<CachedBlockInfo> cachedBlockInfos : floodFill.getFoundTargets().values()) {
            blocksBroken += cachedBlockInfos.size();
            for (CachedBlockInfo info : cachedBlockInfos) {
                if (info.func_177509_a() == null) continue;
                drops.addAll(Block.func_220070_a((BlockState)info.func_177509_a(), (ServerWorld)world, (BlockPos)info.func_177508_d(), (TileEntity)info.func_177507_b()));
                world.func_175655_b(info.func_177508_d(), false);
            }
        }
        world.func_180501_a(floodFill.getLowestPoint(), Blocks.field_185766_cS.func_176223_P(), 7);
        this.damageTool(player, hand, blocksBroken);
        this.takeReplantItem(drops);
        return drops;
    }

    @Override
    protected boolean isEffectiveOn(BlockState state) {
        return fruit.or(notFruit).test(state);
    }
}

