/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.harvester;

import com.ewyboy.quickharvest.config.HarvesterConfig;
import com.ewyboy.quickharvest.harvester.AbstractHarvester;
import com.ewyboy.quickharvest.util.FloodFill;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class KelpHarvester
extends AbstractHarvester {
    private static final Predicate<BlockState> IS_KELP_BLOCK = s -> s.func_177230_c() == Blocks.field_203215_jy;
    private static final Predicate<BlockState> IS_KELP_TOP = s -> s.func_177230_c() == Blocks.field_203214_jx;
    private static final Predicate<BlockState> KELP = IS_KELP_BLOCK.or(IS_KELP_TOP);

    public KelpHarvester(HarvesterConfig config) {
        super(config);
    }

    @Override
    public List<ItemStack> harvest(PlayerEntity player, Hand hand, ServerWorld world, BlockPos pos, BlockState state, Direction side) {
        FloodFill floodFill = new FloodFill(pos, kelpMe -> {
            Direction[] directionArray;
            if (KELP.test((BlockState)kelpMe)) {
                Direction[] directionArray2 = new Direction[2];
                directionArray2[0] = Direction.UP;
                directionArray = directionArray2;
                directionArray2[1] = Direction.DOWN;
            } else {
                directionArray = FloodFill.NO_DIRECTIONS;
            }
            return directionArray;
        }, (Set<Predicate<BlockState>>)ImmutableSet.of(KELP));
        floodFill.search(world);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Set<CachedBlockInfo> kelpBlocks = floodFill.getFoundTargets().get(KELP);
        for (CachedBlockInfo info : kelpBlocks) {
            if (info.func_177508_d() == floodFill.getLowestPoint() || info.func_177509_a() == null) continue;
            drops.addAll(Block.func_220070_a((BlockState)info.func_177509_a(), (ServerWorld)world, (BlockPos)info.func_177508_d(), (TileEntity)info.func_177507_b()));
            world.func_175655_b(info.func_177508_d(), false);
        }
        this.damageTool(player, hand, kelpBlocks.size() - 1);
        this.takeReplantItem(drops);
        return drops;
    }

    @Override
    protected boolean isEffectiveOn(BlockState state) {
        return KELP.test(state);
    }
}

