/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.harvester;

import com.ewyboy.quickharvest.config.HarvesterConfig;
import com.ewyboy.quickharvest.harvester.AbstractHarvester;
import com.ewyboy.quickharvest.util.FloodFill;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class TallPlantHarvester
extends AbstractHarvester {
    private final Predicate<BlockState> plantPredicate = this::isEffectiveOn;
    private final Block plant;

    public TallPlantHarvester(HarvesterConfig config, Block plant) {
        super(config);
        this.plant = plant;
    }

    @Override
    public List<ItemStack> harvest(PlayerEntity player, Hand hand, ServerWorld world, BlockPos pos, BlockState state, Direction side) {
        FloodFill floodFill = new FloodFill(pos, s -> {
            Direction[] directionArray;
            if (this.plantPredicate.test((BlockState)s)) {
                Direction[] directionArray2 = new Direction[2];
                directionArray2[0] = Direction.UP;
                directionArray = directionArray2;
                directionArray2[1] = Direction.DOWN;
            } else {
                directionArray = FloodFill.NO_DIRECTIONS;
            }
            return directionArray;
        }, (Set<Predicate<BlockState>>)ImmutableSet.of(this.plantPredicate));
        floodFill.search(world);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Set<CachedBlockInfo> matches = floodFill.getFoundTargets().get(this.plantPredicate);
        for (CachedBlockInfo info : matches) {
            if (info.func_177508_d().func_177956_o() == floodFill.getLowestPoint().func_177956_o() || info.func_177509_a() == null) continue;
            drops.addAll(Block.func_220070_a((BlockState)info.func_177509_a(), (ServerWorld)world, (BlockPos)info.func_177508_d(), (TileEntity)info.func_177507_b()));
            world.func_175655_b(info.func_177508_d(), false);
        }
        this.damageTool(player, hand, matches.size() - 1);
        return drops;
    }

    @Override
    protected boolean isEffectiveOn(BlockState state) {
        return state.func_177230_c() == this.plant;
    }
}

