/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.setup;

import com.ewyboy.quickharvest.QuickHarvest;
import com.ewyboy.quickharvest.api.Harvester;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="quickharvest")
public class ForgeEventHandlers {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getUseBlock() == Event.Result.DENY || event.getUseItem() == Event.Result.DENY) {
            return;
        }
        World rawWorld = event.getWorld();
        if (!(rawWorld instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)rawWorld;
        PlayerEntity player = event.getPlayer();
        if (player.func_213283_Z() == Pose.CROUCHING) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        Hand hand = event.getHand();
        Direction side = event.getFace();
        for (Harvester harvester : QuickHarvest.Registries.HARVESTERS.getValues()) {
            if (!harvester.enabled() || !harvester.canHarvest(player, hand, world, pos, state, side)) continue;
            harvester.harvest(player, hand, world, pos, state, side).forEach(stack -> ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack));
            player.func_226292_a_(hand, true);
            event.setUseBlock(Event.Result.DENY);
            event.setUseItem(Event.Result.DENY);
            event.setCanceled(true);
            break;
        }
    }
}

