/*
 * Decompiled with CFR 0.152.
 */
package com.mic.randomloot.init;

import com.mic.randomloot.items.SwordItem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.SoundCategory;

public class ItemFields {
    public static String[] adjectives;
    public static String[] nounsS;
    private static Random rand;

    public ItemFields() {
        String[] adjectives = new String[]{"Blazing", "Dark", "Fearsome", "Dainty", "Jewel Encrusted", "Brutal", "Terrifying", "Light", "Heavy", "Serious", "Enlightened", "Swift", "Titanic", "Harsh", "Barbaric", "Crude", "Bloodthirsty", "Heartless", "Merciless", "Ruthless", "Savage", "Cold-Blooded", "Icy", "Fearsome", "Mythic", "Epic", "Legendary", "Awesome", "Incredible", "Shocking"};
        String[] nounsS = new String[]{"Blade", "Sword", "Slasher", "Titan", "Killer", "Cleaver", "Knife", "Cutlass", "Nightmare", "Glaive", "Machete", "Saber", "Claymore", "Doomblade", "Defender", "Striker", "Crusader", "Skewer", "Chaos", "Infinity", "Broadsword", "Shortsword"};
        ItemFields.adjectives = adjectives;
        ItemFields.nounsS = nounsS;
    }

    public static int rollRarity(int caseType) {
        int x;
        boolean tier = false;
        int[] basicChance = new int[]{90, 7, 3};
        int[] goldenChance = new int[]{60, 30, 10};
        int[] titanChance = new int[]{20, 55, 25};
        int[] chance = null;
        switch (caseType) {
            case 1: {
                chance = basicChance;
                break;
            }
            case 2: {
                chance = goldenChance;
                break;
            }
            case 3: {
                chance = titanChance;
            }
        }
        int[] rarity = new int[100];
        for (x = 0; x < chance[0]; ++x) {
            rarity[x] = 1;
        }
        for (x = 0; x < chance[1]; ++x) {
            rarity[chance[0] + x] = 2;
        }
        for (x = 0; x < chance[2]; ++x) {
            rarity[chance[0] + chance[1] + x] = 3;
        }
        return rarity[rand.nextInt(rarity.length)];
    }

    public static String nameItem(String type) {
        String adj = adjectives[rand.nextInt(adjectives.length)];
        String nn = null;
        if (type.equals("sword")) {
            nn = nounsS[rand.nextInt(nounsS.length)];
        }
        return adj + " " + nn;
    }

    public static int calcDamage(int tier) {
        double min = 0.0;
        double max = 0.0;
        switch (tier) {
            case 1: {
                max = 11.0;
                min = 7.0;
                break;
            }
            case 2: {
                max = 16.0;
                min = 10.0;
                break;
            }
            case 3: {
                max = 22.0;
                min = 15.0;
            }
        }
        return (int)(min + (max - min) * rand.nextDouble());
    }

    public static double calcSpeed(int tier) {
        double min = 0.0;
        double max = 0.0;
        switch (tier) {
            case 1: {
                max = 2.4;
                min = 2.0;
                break;
            }
            case 2: {
                max = 2.1;
                min = 1.8;
                break;
            }
            case 3: {
                max = 2.0;
                min = 1.2;
            }
        }
        return min + (max - min) * rand.nextDouble();
    }

    public static float displaySpeed(double spd) {
        return (float)(Minecraft.func_71410_x().field_71439_g.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111125_b() + spd);
    }

    public void upgrade(ItemStack stack) {
        Minecraft.func_71410_x().field_71439_g.func_130014_f_().func_184133_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71439_g.func_180425_c(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 1.0f, 1.0f);
        NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagList modifiers = new NBTTagList();
        int lvl = compound.func_74762_e("Lvl");
        compound.func_74768_a("Lvl", ++lvl);
        int dmg = compound.func_74762_e("damage");
        System.out.println(dmg);
        double spd = compound.func_74769_h("speed");
        switch (rand.nextInt(2) + 1) {
            case 1: {
                ++dmg;
                break;
            }
            case 2: {
                spd += 0.05;
            }
        }
        NBTTagCompound damage = new NBTTagCompound();
        damage.func_74782_a("AttributeName", (NBTBase)new NBTTagString("generic.attackDamage"));
        damage.func_74782_a("Name", (NBTBase)new NBTTagString("generic.attackDamage"));
        damage.func_74782_a("Amount", (NBTBase)new NBTTagInt(dmg));
        damage.func_74782_a("Operation", (NBTBase)new NBTTagInt(0));
        damage.func_74782_a("UUIDLeast", (NBTBase)new NBTTagInt(3));
        damage.func_74782_a("UUIDMost", (NBTBase)new NBTTagInt(4));
        damage.func_74782_a("Slot", (NBTBase)new NBTTagString("mainhand"));
        NBTTagCompound speed = new NBTTagCompound();
        speed.func_74782_a("AttributeName", (NBTBase)new NBTTagString("generic.attackSpeed"));
        speed.func_74782_a("Name", (NBTBase)new NBTTagString("generic.attackSpeed"));
        speed.func_74782_a("Amount", (NBTBase)new NBTTagDouble(spd));
        speed.func_74782_a("Operation", (NBTBase)new NBTTagInt(0));
        speed.func_74782_a("UUIDLeast", (NBTBase)new NBTTagInt(1));
        speed.func_74782_a("UUIDMost", (NBTBase)new NBTTagInt(2));
        speed.func_74782_a("Slot", (NBTBase)new NBTTagString("mainhand"));
        int lvlXp = compound.func_74762_e("lvlXp");
        compound.func_74768_a("Xp", 0);
        lvlXp += lvlXp / 2;
        compound.func_74768_a("lvlXp", lvlXp);
        compound.func_74768_a("damage", dmg);
        compound.func_74780_a("speed", spd);
        modifiers.func_74742_a((NBTBase)damage);
        modifiers.func_74742_a((NBTBase)speed);
        compound.func_74782_a("AttributeModifiers", (NBTBase)modifiers);
        stack.func_77982_d(compound);
        SwordItem.setLore(stack);
    }

    static {
        rand = new Random();
    }
}

