/*
 * Decompiled with CFR 0.152.
 */
package com.mic.randomloot.items;

import com.mic.randomloot.init.ItemFields;
import com.mic.randomloot.init.ModItems;
import com.mic.randomloot.items.ItemBase;
import com.mic.randomloot.items.SwordItem;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CaseItem
extends ItemBase {
    private static final UUID MODIFIER_UUID = UUID.fromString("294093da-54f0-4c1b-9dbb-13b77534a84c");
    protected int level;

    public CaseItem(String name, int level) {
        super(name);
        this.level = level;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        boolean success;
        if (!worldIn.field_72995_K && (success = playerIn.field_71071_by.func_70441_a(this.getItem(worldIn)))) {
            playerIn.func_184586_b(handIn).func_190918_g(1);
        }
        for (int countparticles = 0; countparticles <= 10; ++countparticles) {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        worldIn.func_184133_a(playerIn, playerIn.func_180425_c(), SoundEvents.field_187546_ae, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ItemStack getItem(World worldIn) {
        Random rand = new Random();
        Item iChoice = ModItems.RL_SWORD;
        ItemStack item = new ItemStack(iChoice);
        item = SwordItem.assignType(item);
        item.func_77973_b().func_185043_a(new ResourceLocation("model"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                float model = 1.0f;
                model = SwordItem.getTexture(stack);
                return model;
            }
        });
        int rarity = ItemFields.rollRarity(this.level);
        NBTTagCompound compound = item.func_77942_o() ? item.func_77978_p() : new NBTTagCompound();
        NBTTagList modifiers = new NBTTagList();
        NBTTagCompound damage = new NBTTagCompound();
        damage.func_74782_a("AttributeName", (NBTBase)new NBTTagString("generic.attackDamage"));
        damage.func_74782_a("Name", (NBTBase)new NBTTagString("generic.attackDamage"));
        int dmg = ItemFields.calcDamage(rarity);
        damage.func_74782_a("Amount", (NBTBase)new NBTTagInt(dmg));
        damage.func_74782_a("Operation", (NBTBase)new NBTTagInt(0));
        damage.func_74782_a("UUIDLeast", (NBTBase)new NBTTagInt(3));
        damage.func_74782_a("UUIDMost", (NBTBase)new NBTTagInt(4));
        damage.func_74782_a("Slot", (NBTBase)new NBTTagString("mainhand"));
        NBTTagCompound speed = new NBTTagCompound();
        speed.func_74782_a("AttributeName", (NBTBase)new NBTTagString("generic.attackSpeed"));
        speed.func_74782_a("Name", (NBTBase)new NBTTagString("generic.attackSpeed"));
        double spd = ItemFields.calcSpeed(rarity) * -1.0;
        speed.func_74782_a("Amount", (NBTBase)new NBTTagDouble(spd));
        speed.func_74782_a("Operation", (NBTBase)new NBTTagInt(0));
        speed.func_74782_a("UUIDLeast", (NBTBase)new NBTTagInt(1));
        speed.func_74782_a("UUIDMost", (NBTBase)new NBTTagInt(2));
        speed.func_74782_a("Slot", (NBTBase)new NBTTagString("mainhand"));
        compound.func_74768_a("damage", dmg);
        compound.func_74780_a("speed", spd);
        compound.func_74778_a("name", ItemFields.nameItem("sword"));
        compound.func_74768_a("rarity", rarity);
        modifiers.func_74742_a((NBTBase)damage);
        modifiers.func_74742_a((NBTBase)speed);
        compound.func_74782_a("AttributeModifiers", (NBTBase)modifiers);
        item.func_77982_d(compound);
        SwordItem.setLore(item);
        return item;
    }

    public static ItemStack upgradeSword(ItemSword item) {
        float swordDamage = 4.0f + item.func_150931_i();
        AttributeModifier attackModifier = new AttributeModifier(MODIFIER_UUID, "Weapon Upgrade", (double)(30.0f + swordDamage), 0);
        NBTTagCompound modifierNBT = CaseItem.writeAttributeModifierToNBT(SharedMonsterAttributes.field_111264_e, attackModifier);
        NBTTagCompound stackTagCompound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)modifierNBT);
        stackTagCompound.func_74782_a("AttributeModifiers", (NBTBase)list);
        ItemStack stack = new ItemStack((Item)item);
        stack.func_77982_d(stackTagCompound);
        return stack;
    }

    private static NBTTagCompound writeAttributeModifierToNBT(IAttribute attribute, AttributeModifier modifier) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74778_a("AttributeName", attribute.func_111108_a());
        nbttagcompound.func_74778_a("Name", modifier.func_111166_b());
        nbttagcompound.func_74780_a("Amount", modifier.func_111164_d());
        nbttagcompound.func_74768_a("Operation", modifier.func_111169_c());
        nbttagcompound.func_74772_a("UUIDMost", modifier.func_111167_a().getMostSignificantBits());
        nbttagcompound.func_74772_a("UUIDLeast", modifier.func_111167_a().getLeastSignificantBits());
        return nbttagcompound;
    }
}

