/*
 * Decompiled with CFR 0.152.
 */
package com.mic.randomloot.items;

import com.mic.randomloot.RandomLoot;
import com.mic.randomloot.init.ItemFields;
import com.mic.randomloot.init.ModItems;
import com.mic.randomloot.util.IHasModel;
import java.text.DecimalFormat;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SwordItem
extends ItemSword
implements IHasModel {
    private static int swords;
    private static int tCount;

    public SwordItem(Item.ToolMaterial material, int swords) {
        super(material);
        SwordItem.swords = swords;
        this.func_77637_a(RandomLoot.modTab);
        this.setRegistryName(new ResourceLocation("randomloot", "sword"));
        this.func_77655_b("sword");
        ModItems.ITEMS.add((Item)this);
        this.func_185043_a(new ResourceLocation("model"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                float model = 1.0f;
                model = SwordItem.getTexture(stack);
                return model;
            }
        });
    }

    public static int getTexture(ItemStack stack) {
        int value = 0;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Texture")) {
            value = stack.func_77978_p().func_74762_e("Texture");
        }
        return value;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        int lvlXp;
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        int xp = nbt.func_74762_e("Xp");
        if (xp >= (lvlXp = nbt.func_74762_e("lvlXp"))) {
            ModItems.ITEM_FIELDS.upgrade(stack);
        }
        int t1 = nbt.func_74762_e("T1");
        int t2 = nbt.func_74762_e("T2");
        int t3 = nbt.func_74762_e("T3");
        if (t1 == 1 || t2 == 1 || t3 == 1) {
            target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100, 0));
        }
        if (t1 == 2 || t2 == 2 || t3 == 2) {
            target.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 1));
        }
        if (t1 == 3 || t2 == 3 || t3 == 3) {
            target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 100, 0));
        }
        if (t1 == 4 || t2 == 4 || t3 == 4) {
            target.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 160, 0));
        }
        if (t1 == 5 || t2 == 5 || t3 == 5) {
            target.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 200, 0));
        }
        if (t1 == 6 || t2 == 6 || t3 == 6) {
            target.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 200, 0));
        }
        if (t1 == 7 || t2 == 7 || t3 == 7) {
            target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 0));
        }
        if (t1 == 8 || t2 == 8 || t3 == 8) {
            target.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 200, 0));
        }
        if (t1 == 10 || t2 == 10 || t3 == 10) {
            attacker.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 1, (int)((double)target.func_110143_aJ() * 0.1)));
        }
        if (t1 == 11 || t2 == 11 || t3 == 11) {
            attacker.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 100, 1));
        }
        if (nbt.func_74764_b("Xp")) {
            nbt.func_74768_a("Xp", nbt.func_74762_e("Xp") + 1);
        } else {
            nbt.func_74768_a("Xp", 1);
        }
        stack.func_77982_d(nbt);
        SwordItem.setLore(stack);
        return super.func_77644_a(stack, target, attacker);
    }

    public static void setLore(ItemStack stack) {
        NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        TextFormatting color = null;
        switch (compound.func_74762_e("rarity")) {
            case 1: {
                color = TextFormatting.WHITE;
                break;
            }
            case 2: {
                color = TextFormatting.GOLD;
                break;
            }
            case 3: {
                color = TextFormatting.LIGHT_PURPLE;
            }
        }
        NBTTagList lore = new NBTTagList();
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "Attack Damage: " + compound.func_74762_e("damage")));
        DecimalFormat f = new DecimalFormat("##.00");
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "Attack Speed: " + f.format(ItemFields.displaySpeed(compound.func_74769_h("speed")))));
        lore.func_74742_a((NBTBase)new NBTTagString(""));
        int t1 = compound.func_74762_e("T1");
        int t2 = compound.func_74762_e("T2");
        int t3 = compound.func_74762_e("T3");
        if (t1 == 1 || t2 == 1 || t3 == 1) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.DARK_GREEN + "Poisonous"));
        }
        if (t1 == 2 || t2 == 2 || t3 == 2) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.DARK_GRAY + "Weakening"));
        }
        if (t1 == 3 || t2 == 3 || t3 == 3) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.DARK_GRAY + "Withering"));
        }
        if (t1 == 4 || t2 == 4 || t3 == 4) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.DARK_GRAY + "Blinding"));
        }
        if (t1 == 5 || t2 == 5 || t3 == 5) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.DARK_RED + "Starving"));
        }
        if (t1 == 6 || t2 == 6 || t3 == 6) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GOLD + "Levitating"));
        }
        if (t1 == 7 || t2 == 7 || t3 == 7) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.DARK_BLUE + "Slowing"));
        }
        if (t1 == 8 || t2 == 8 || t3 == 8) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.YELLOW + "Glowing"));
        }
        if (t1 == 9 || t2 == 9 || t3 == 9) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "Fortified"));
        }
        if (t1 == 10 || t2 == 10 || t3 == 10) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.DARK_RED + "Leaching"));
        }
        if (t1 == 11 || t2 == 11 || t3 == 11) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.LIGHT_PURPLE + "Bezerker"));
        }
        lore.func_74742_a((NBTBase)new NBTTagString(""));
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "Level " + compound.func_74762_e("Lvl")));
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "" + compound.func_74762_e("Xp") + "/" + compound.func_74762_e("lvlXp") + " Xp"));
        NBTTagCompound display = new NBTTagCompound();
        display.func_74782_a("Lore", (NBTBase)lore);
        compound.func_74782_a("display", (NBTBase)display);
        stack.func_151001_c(color + compound.func_74779_i("name"));
    }

    public static ItemStack assignType(ItemStack stack) {
        Random rand = new Random();
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        int t1 = 0;
        int t2 = 0;
        int t3 = 0;
        int traits = 0;
        int ts = rand.nextInt(8);
        switch (ts) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                traits = 1;
                break;
            }
            case 5: 
            case 6: {
                traits = 2;
                break;
            }
            case 7: {
                traits = 3;
            }
        }
        if (traits == 1) {
            t1 = rand.nextInt(tCount) + 1;
        } else if (traits == 2) {
            t1 = rand.nextInt(tCount) + 1;
            rand.setSeed(t1);
            t2 = rand.nextInt(tCount) + 1;
        } else if (traits == 3) {
            t1 = rand.nextInt(tCount) + 1;
            rand.setSeed(t1);
            t2 = rand.nextInt(tCount) + 1;
            rand.setSeed(t2);
            t3 = rand.nextInt(tCount) + 1;
        }
        if (t1 == 9 || t2 == 9 || t3 == 9) {
            nbt.func_74757_a("Unbreakable", true);
        }
        nbt.func_74768_a("T1", t1);
        nbt.func_74768_a("T2", t2);
        nbt.func_74768_a("T3", t3);
        nbt.func_74768_a("Lvl", 1);
        nbt.func_74768_a("lvlXp", 256);
        nbt.func_74768_a("Xp", 0);
        rand.setSeed(rand.nextInt(256));
        nbt.func_74768_a("Texture", rand.nextInt(swords) + 1);
        nbt.func_74768_a("HideFlags", 2);
        stack.func_77982_d(nbt);
        return stack;
    }

    @Override
    public void registerModels() {
        RandomLoot.proxy.registerItemRenderer((Item)this, 0, "inventory");
    }

    static {
        tCount = 11;
    }
}

