/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rareice.forge;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import me.shedaniel.rareice.forge.blocks.RareIceBlock;
import me.shedaniel.rareice.forge.blocks.entities.RareIceTileEntity;
import me.shedaniel.rareice.forge.world.gen.feature.RareIceConfig;
import me.shedaniel.rareice.forge.world.gen.feature.RareIceFeature;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="rare-ice")
public class RareIce {
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITY_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"rare-ice");
    public static final DeferredRegister<Block> BLOCK_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"rare-ice");
    public static final RegistryObject<Block> RARE_ICE_BLOCK = BLOCK_REGISTRY.register("rare_ice", () -> new RareIceBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150432_aD).func_235827_a_((state, world, pos, type) -> type == EntityType.field_200786_Z).harvestTool(ToolType.PICKAXE).harvestLevel(0)));
    public static final RegistryObject<TileEntityType<RareIceTileEntity>> RARE_ICE_TILE_ENTITY_TYPE = TILE_ENTITY_REGISTRY.register("rare_ice", () -> TileEntityType.Builder.func_223042_a(RareIceTileEntity::new, (Block[])new Block[]{(Block)RARE_ICE_BLOCK.get()}).func_206865_a(null));
    public static final Feature<RareIceConfig> RARE_ICE_FEATURE = new RareIceFeature(RareIceConfig.CODEC);
    public static boolean allowInsertingItemsToIce = true;
    public static int probabilityOfRareIce = 6;

    private static void loadConfig(Path file) {
        allowInsertingItemsToIce = true;
        probabilityOfRareIce = 6;
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Properties properties = new Properties();
                properties.load(Files.newBufferedReader(file));
                allowInsertingItemsToIce = properties.getProperty("allowInsertingItemsToIce", "true").equals("true");
                probabilityOfRareIce = Integer.parseInt(properties.getProperty("probabilityOfRareIce", "6"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        RareIce.saveConfig(file);
    }

    private static void saveConfig(Path file) {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Properties properties = new Properties();
            properties.setProperty("allowInsertingItemsToIce", String.valueOf(allowInsertingItemsToIce));
            properties.setProperty("probabilityOfRareIce", String.valueOf(probabilityOfRareIce));
            properties.store(Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE), "Rare Ice Configuration");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RareIce() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCK_REGISTRY.register(bus);
        TILE_ENTITY_REGISTRY.register(bus);
        bus.addListener(RareIce::onCommonSetup);
        MinecraftForge.EVENT_BUS.addListener(RareIce::rightClickBlock);
    }

    public static void onCommonSetup(FMLCommonSetupEvent event) {
        RareIce.loadConfig(FMLPaths.CONFIGDIR.get().resolve("rare-ice.properties"));
        ForgeRegistries.BIOMES.getValues().stream().filter(biome -> biome.func_185353_n() < 0.15f).forEach(RareIce::handleBiome);
    }

    private static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!allowInsertingItemsToIce) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player.func_225608_bj_()) {
            return;
        }
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150432_aD || state.func_177230_c() == RARE_ICE_BLOCK.get()) {
            TileEntity blockEntity = world.func_175625_s(pos);
            if (blockEntity == null) {
                world.func_175656_a(pos, ((Block)RARE_ICE_BLOCK.get()).func_176223_P());
                blockEntity = world.func_175625_s(pos);
            }
            if (blockEntity instanceof RareIceTileEntity) {
                RareIceTileEntity rareIceBlockEntity = (RareIceTileEntity)blockEntity;
                ItemStack itemStack = player.func_184586_b(event.getHand());
                itemStack = player.field_71075_bZ.field_75098_d ? itemStack.func_77946_l() : itemStack;
                ActionResultType type = rareIceBlockEntity.addItem(world, itemStack, player, event.getSide().isServer());
                if (type != ActionResultType.PASS) {
                    event.setCanceled(true);
                }
                event.setCancellationResult(type);
            }
        }
    }

    private static void handleBiome(Biome biome) {
        if (biome.func_185353_n() < 0.15f) {
            biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, RARE_ICE_FEATURE.func_225566_b_((IFeatureConfig)RareIceConfig.DEFAULT).func_227228_a_(Placement.field_215031_q.func_227446_a_((IPlacementConfig)new CountRangeConfig(probabilityOfRareIce, 32, 128, 256))));
        }
    }
}

