/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.trade;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.json.JsonFormat;
import java.util.LinkedHashMap;
import java.util.Random;
import logictechcorp.libraryex.trade.TradeStack;
import logictechcorp.libraryex.utility.ConfigHelper;
import logictechcorp.libraryex.utility.RandomHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;

public class Trade
extends MerchantRecipe {
    protected TradeStack output;
    protected TradeStack inputOne;
    protected TradeStack inputTwo;
    protected int minTradeCount;
    protected int maxTradeCount;
    protected int tradeLevel;
    private String identifier;

    public Trade(TradeStack output, TradeStack inputOne, TradeStack inputTwo, int minTradeCount, int maxTradeCount, int tradeLevel) {
        super(inputOne.getItemStack(), inputTwo.getItemStack(), output.getItemStack(), 0, maxTradeCount);
        this.output = output;
        this.inputOne = inputOne;
        this.inputTwo = inputTwo;
        this.minTradeCount = minTradeCount;
        this.maxTradeCount = maxTradeCount;
        this.tradeLevel = tradeLevel;
        ItemStack outputStack = this.output.getItemStack().func_77946_l();
        ItemStack inputOneStack = this.inputOne.getItemStack().func_77946_l();
        this.identifier = outputStack.func_77973_b().getRegistryName() + "@" + outputStack.func_77952_i();
        this.identifier = this.identifier + "=" + inputOneStack.func_77973_b().getRegistryName() + "@" + inputOneStack.func_77952_i();
        if (this.func_77398_c()) {
            ItemStack inputTwoStack = this.inputTwo.getItemStack().func_77946_l();
            this.identifier = this.identifier + "+" + inputTwoStack.func_77973_b().getRegistryName() + "@" + inputTwoStack.func_77952_i();
        }
    }

    public Trade(Config config) {
        this(new TradeStack(config, "output"), new TradeStack(config, "inputOne"), new TradeStack(config, "inputTwo"), (Integer)config.getOrElse("minTradeCount", (Object)1), (Integer)config.getOrElse("maxTradeCount", (Object)8), (Integer)config.getOrElse("tradeLevel", (Object)1));
    }

    public MerchantRecipe randomize(Random random) {
        ItemStack outputStack = this.output.getItemStack().func_77946_l();
        ItemStack inputOneStack = this.inputOne.getItemStack().func_77946_l();
        ItemStack inputTwoStack = this.inputTwo.getItemStack().func_77946_l();
        outputStack.func_190920_e(RandomHelper.getNumberInRange(this.output.getMinCount(), this.output.getMaxCount(), random));
        inputOneStack.func_190920_e(RandomHelper.getNumberInRange(this.inputOne.getMinCount(), this.inputOne.getMaxCount(), random));
        if (this.func_77398_c()) {
            inputTwoStack.func_190920_e(RandomHelper.getNumberInRange(this.inputTwo.getMinCount(), this.inputTwo.getMaxCount(), random));
        }
        int tradesAvailable = RandomHelper.getNumberInRange(this.minTradeCount, this.maxTradeCount, random);
        return new MerchantRecipe(inputOneStack, inputTwoStack, outputStack, 0, tradesAvailable);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public TradeStack getOutput() {
        return this.output;
    }

    public TradeStack getInputOne() {
        return this.inputOne;
    }

    public TradeStack getInputTwo() {
        return this.inputTwo;
    }

    public int getMinTradeCount() {
        return this.minTradeCount;
    }

    public int getMaxTradeCount() {
        return this.maxTradeCount;
    }

    public int getTradeLevel() {
        return this.tradeLevel;
    }

    public Config getAsConfig() {
        Config tradeConfig = JsonFormat.newConfig(LinkedHashMap::new);
        ConfigHelper.setItemStackSimple(tradeConfig, "output", this.output.getItemStack());
        tradeConfig.set("output.minCount", (Object)this.output.getMinCount());
        tradeConfig.set("output.maxCount", (Object)this.output.getMaxCount());
        ConfigHelper.setItemStackSimple(tradeConfig, "inputOne", this.inputOne.getItemStack());
        tradeConfig.set("inputOne.minCount", (Object)this.inputOne.getMinCount());
        tradeConfig.set("inputOne.maxCount", (Object)this.inputOne.getMaxCount());
        if (this.func_77398_c()) {
            ConfigHelper.setItemStackSimple(tradeConfig, "inputTwo", this.inputTwo.getItemStack());
            tradeConfig.set("inputTwo.minCount", (Object)this.inputTwo.getMinCount());
            tradeConfig.set("inputTwo.maxCount", (Object)this.inputTwo.getMaxCount());
        }
        tradeConfig.set("minTradeCount", (Object)this.minTradeCount);
        tradeConfig.set("maxTradeCount", (Object)this.maxTradeCount);
        tradeConfig.set("tradeLevel", (Object)this.tradeLevel);
        return tradeConfig;
    }

    public boolean func_77398_c() {
        return !this.inputTwo.getItemStack().func_190926_b();
    }

    public boolean equals(Object object) {
        if (object instanceof Trade) {
            return object == this || ((Trade)((Object)object)).getIdentifier().equals(this.identifier);
        }
        return false;
    }
}

