/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant.block;

import java.util.Random;
import logictechcorp.libraryex.block.BlockTileEntity;
import logictechcorp.libraryex.block.property.BlockProperties;
import logictechcorp.reagenchant.Reagenchant;
import logictechcorp.reagenchant.tileentity.TileEntityReagentTable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockReagentTable
extends BlockTileEntity<TileEntityReagentTable> {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);

    public BlockReagentTable() {
        super(Blocks.field_150381_bn.getRegistryName(), TileEntityReagentTable.class, new BlockProperties(Material.field_151576_e, MapColor.field_151645_D).hardness(5.0f).resistance(2000.0f));
        this.func_149713_g(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        for (int x = -2; x <= 2; ++x) {
            block1: for (int z = -2; z <= 2; ++z) {
                if (x > -2 && x < 2 && z == -1) {
                    z = 2;
                }
                if (rand.nextInt(16) != 0) continue;
                for (int y = 0; y <= 1; ++y) {
                    BlockPos blockpos = pos.func_177982_a(x, y, z);
                    if (!(ForgeHooks.getEnchantPower((World)world, (BlockPos)blockpos) > 0.0f)) continue;
                    if (!world.func_175623_d(pos.func_177982_a(x / 2, 0, z / 2))) continue block1;
                    world.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.0, (double)pos.func_177952_p() + 0.5, (double)((float)x + rand.nextFloat()) - 0.5, (double)((float)y - rand.nextFloat() - 1.0f), (double)((float)z + rand.nextFloat()) - 0.5, new int[0]);
                }
            }
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        super.func_180633_a(world, pos, state, placer, stack);
        if (stack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof TileEntityReagentTable) {
            ((TileEntityReagentTable)tileentity).setCustomName(stack.func_82833_r());
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (world.field_72995_K) {
            return true;
        }
        if (world.func_175625_s(pos) instanceof TileEntityEnchantmentTable) {
            world.func_175690_a(pos, this.createTileEntity(world, state));
        }
        if ((tileEntity = world.func_175625_s(pos)) instanceof TileEntityReagentTable && ((TileEntityReagentTable)tileEntity).getUser() == null) {
            player.openGui((Object)Reagenchant.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }
}

