/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant.compatibility.jei;

import java.util.List;
import java.util.Map;
import logictechcorp.reagenchant.compatibility.jei.ReagentWrapper;
import logictechcorp.reagenchant.init.ReagenchantBlocks;
import logictechcorp.reagenchant.init.ReagenchantTextures;
import logictechcorp.reagenchant.reagent.Reagent;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;

class ReagentTableCategory
implements IRecipeCategory<ReagentWrapper> {
    static final String ID = "reagenchant:reagent_table";
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private final IDrawable background;
    private final IDrawable icon;
    private final String title;

    ReagentTableCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ReagenchantTextures.REAGENT_TABLE_RECIPE_GUI, 0, 0, 79, 25);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((Block)ReagenchantBlocks.REAGENT_TABLE));
        this.title = I18n.func_135052_a((String)"gui.reagenchant:reagent_table.title", (Object[])new Object[0]);
    }

    public String getUid() {
        return ID;
    }

    public String getTitle() {
        return this.title;
    }

    public String getModName() {
        return "Reagenchant";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, ReagentWrapper reagentWrapper, IIngredients ingredients) {
        Reagent reagent = reagentWrapper.getReagent();
        recipeLayout.getIngredientsGroup(VanillaTypes.ITEM).addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)ingredient);
            for (Map.Entry entry : enchantments.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                int level = (Integer)entry.getValue();
                tooltip.add("");
                tooltip.add(enchantment.func_77316_c(level));
                tooltip.add(I18n.func_135052_a((String)"gui.reagenchant:reagent_table.probability.base", (Object[])new Object[]{reagent.getReagentEnchantmentData(enchantment).getEnchantmentProbability() * 100.0}));
                tooltip.add(I18n.func_135052_a((String)"gui.reagenchant:reagent_table.reagent.base_cost", (Object[])new Object[]{reagent.getReagentEnchantmentData(enchantment).getReagentCost()}));
            }
        });
        recipeLayout.getItemStacks().init(0, true, 0, 4);
        recipeLayout.getItemStacks().init(1, false, 58, 4);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

