/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant.handler;

import java.util.List;
import logictechcorp.libraryex.utility.NBTHelper;
import logictechcorp.reagenchant.Reagenchant;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Bootstrap;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatList;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="reagenchant")
public class UnbreakingHandler {
    private static final ResourceLocation BROKEN_PROPERTY_KEY = Reagenchant.getResource("broken");
    private static final IItemPropertyGetter BROKEN_PROPERTY = new IItemPropertyGetter(){

        @SideOnly(value=Side.CLIENT)
        public float func_185085_a(ItemStack stack, World world, EntityLivingBase entity) {
            return UnbreakingHandler.isItemConsideredBroken(stack) ? 1.0f : 0.0f;
        }
    };
    private static final String BROKEN_KEY = "reagenchant:Broken";
    private static final String DISABLED_ENCHANTMENTS_KEY = "reagenchant:DisabledEnchantments";

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        List tooltips = event.getToolTip();
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b(DISABLED_ENCHANTMENTS_KEY)) {
            for (int tooltipIndex = 0; tooltipIndex < tooltips.size(); ++tooltipIndex) {
                String tooltip = (String)tooltips.get(tooltipIndex);
                if (!tooltip.equals(I18n.func_74838_a((String)"item.modifiers.mainhand"))) continue;
                NBTTagList disabledEnchantments = compound.func_150295_c(DISABLED_ENCHANTMENTS_KEY, 10);
                int enchantmentCount = disabledEnchantments.func_74745_c();
                for (int tagIndex = 0; tagIndex < enchantmentCount; ++tagIndex) {
                    NBTTagCompound enchantmentCompound = disabledEnchantments.func_150305_b(tagIndex);
                    Enchantment enchantment = Enchantment.func_185262_c((int)enchantmentCompound.func_74765_d("id"));
                    int index = tooltipIndex + tagIndex - 1;
                    if (enchantment != null) {
                        tooltips.add(index, TextFormatting.GOLD + enchantment.func_77316_c((int)enchantmentCompound.func_74765_d("lvl")));
                    }
                    if (tagIndex + 1 != enchantmentCount) continue;
                    tooltips.add(index + 1, TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.reagenchant:item.broken"));
                }
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184614_ca();
        if (UnbreakingHandler.isItemConsideredBroken(stack)) {
            event.setNewSpeed(0.5f);
        }
    }

    @SubscribeEvent
    public static void onPlayerHarvestCheck(PlayerEvent.HarvestCheck event) {
        EntityPlayer player = event.getEntityPlayer();
        IBlockState state = event.getTargetBlock();
        ItemStack stack = player.func_184614_ca();
        if (UnbreakingHandler.isItemConsideredBroken(stack) && !state.func_185904_a().func_76229_l()) {
            event.setCanHarvest(false);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getState();
        EntityPlayer player = event.getPlayer();
        Block block = state.func_177230_c();
        ItemStack stack = player.func_184614_ca();
        if (UnbreakingHandler.isItemConsideredBroken(stack)) {
            if (block instanceof IShearable && ((IShearable)block).isShearable(stack, (IBlockAccess)world, pos)) {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
            if (!state.func_185904_a().func_76229_l()) {
                event.setExpToDrop(0);
            }
        }
    }

    @SubscribeEvent
    public static void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        ItemStack stack;
        IBlockState state = event.getState();
        EntityPlayer player = event.getHarvester();
        if (player != null && UnbreakingHandler.isItemConsideredBroken(stack = event.getHarvester().func_184614_ca())) {
            UnbreakingHandler.breakItem((EntityLivingBase)player, stack);
            if (!state.func_185904_a().func_76229_l()) {
                event.getDrops().clear();
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        if (UnbreakingHandler.isItemConsideredBroken(stack)) {
            UnbreakingHandler.breakItem((EntityLivingBase)player, stack);
            event.setUseItem(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (UnbreakingHandler.isItemConsideredBroken(stack) && !(item instanceof ItemArmor) && !(item instanceof ISpecialArmor)) {
            UnbreakingHandler.breakItem((EntityLivingBase)player, stack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        Entity entity = event.getTarget();
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (UnbreakingHandler.isItemConsideredBroken(stack)) {
            UnbreakingHandler.breakItem((EntityLivingBase)player, stack);
            if (entity instanceof EntityLivingBase && item.func_111207_a(ItemStack.field_190927_a, event.getEntityPlayer(), (EntityLivingBase)entity, event.getHand())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        EntityPlayer player;
        ItemStack stack;
        Entity attacked = event.getEntity();
        DamageSource source = event.getSource();
        Entity attacker = source.func_76346_g();
        if (attacker instanceof EntityPlayer && UnbreakingHandler.isItemConsideredBroken(stack = (player = (EntityPlayer)attacker).func_184614_ca())) {
            UnbreakingHandler.breakItem((EntityLivingBase)player, stack);
            event.setAmount(1.0f);
        }
        if (attacked instanceof EntityPlayer) {
            UnbreakingHandler.damagePlayer((EntityPlayer)attacked, source, event.getAmount());
            event.setAmount(0.0f);
        }
    }

    @SubscribeEvent
    public static void onAnvilRepair(AnvilRepairEvent event) {
        ItemStack inputStack = event.getItemInput();
        ItemStack outputStack = event.getItemResult();
        if (UnbreakingHandler.isItemConsideredBroken(inputStack) && outputStack.func_77952_i() < inputStack.func_77952_i()) {
            UnbreakingHandler.fixItem(outputStack);
        }
    }

    @SubscribeEvent
    public static void onMending(PlayerPickupXpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        for (EnumHand hand : EnumHand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            if (!UnbreakingHandler.isItemConsideredBroken(stack) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)stack) <= 0) continue;
            UnbreakingHandler.fixItem(stack);
        }
    }

    public static void overrideBehavior() {
        for (Item item : ForgeRegistries.ITEMS) {
            item.func_185043_a(BROKEN_PROPERTY_KEY, BROKEN_PROPERTY);
        }
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151033_d, (Object)new Bootstrap.BehaviorDispenseOptional(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                this.field_190911_b = false;
                if (!UnbreakingHandler.isItemConsideredBroken(stack)) {
                    World world = source.func_82618_k();
                    BlockPos pos = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
                    this.field_190911_b = true;
                    if (world.func_175623_d(pos)) {
                        world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                        if (stack.func_96631_a(1, world.field_73012_v, null)) {
                            stack.func_190920_e(0);
                        }
                    } else if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150335_W) {
                        Blocks.field_150335_W.func_176206_d(world, pos, Blocks.field_150335_W.func_176223_P().func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)));
                        world.func_175698_g(pos);
                    }
                }
                return stack;
            }
        });
    }

    private static void breakItem(EntityLivingBase livingEntity, ItemStack stack) {
        NBTTagCompound stackCompound = NBTHelper.ensureTagExists((ItemStack)stack);
        if (!stackCompound.func_74767_n(BROKEN_KEY)) {
            NBTTagList enchantments = stack.func_77986_q();
            NBTTagList disabledEnchantments = new NBTTagList();
            if (!stackCompound.func_74764_b(DISABLED_ENCHANTMENTS_KEY)) {
                for (int tagIndex = 0; tagIndex < enchantments.func_74745_c(); ++tagIndex) {
                    short enchantmentId = enchantments.func_150305_b(tagIndex).func_74765_d("id");
                    if (enchantmentId == Enchantment.func_185258_b((Enchantment)Enchantments.field_190941_k)) {
                        enchantments.func_74744_a(tagIndex);
                        continue;
                    }
                    if (enchantmentId == Enchantment.func_185258_b((Enchantment)Enchantments.field_185307_s) || enchantmentId == Enchantment.func_185258_b((Enchantment)Enchantments.field_185296_A)) continue;
                    disabledEnchantments.func_74742_a(enchantments.func_74744_a(tagIndex));
                }
                stackCompound.func_74782_a(DISABLED_ENCHANTMENTS_KEY, (NBTBase)disabledEnchantments);
            }
            livingEntity.func_70669_a(stack);
            stackCompound.func_74757_a(BROKEN_KEY, true);
        }
    }

    private static void fixItem(ItemStack stack) {
        NBTTagCompound stackCompound = NBTHelper.ensureTagExists((ItemStack)stack);
        if (stackCompound.func_74767_n(BROKEN_KEY)) {
            NBTTagList enchantments = stack.func_77986_q();
            if (stackCompound.func_74764_b(DISABLED_ENCHANTMENTS_KEY)) {
                NBTTagList disabledEnchantments = stackCompound.func_150295_c(DISABLED_ENCHANTMENTS_KEY, 10);
                for (int tagIndex = 0; tagIndex < disabledEnchantments.func_74745_c(); ++tagIndex) {
                    enchantments.func_74742_a(disabledEnchantments.func_74744_a(tagIndex));
                }
            }
            stackCompound.func_82580_o(DISABLED_ENCHANTMENTS_KEY);
            stackCompound.func_74782_a("ench", (NBTBase)enchantments);
            stackCompound.func_74757_a(BROKEN_KEY, false);
        }
    }

    private static void damagePlayer(EntityPlayer player, DamageSource source, float amount) {
        ItemStack armorStack;
        int i;
        NonNullList armorStacks = player.field_71071_by.field_70460_b;
        NonNullList brokenArmorStacks = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        for (int i2 = 0; i2 < armorStacks.size(); ++i2) {
            if (!UnbreakingHandler.isItemConsideredBroken((ItemStack)armorStacks.get(i2))) continue;
            brokenArmorStacks.set(i2, armorStacks.set(i2, (Object)ItemStack.field_190927_a));
        }
        float damage = ISpecialArmor.ArmorProperties.applyArmor((EntityLivingBase)player, (NonNullList)armorStacks, (DamageSource)source, (double)amount);
        if (!source.func_151517_h()) {
            if (player.func_70644_a(MobEffects.field_76429_m) && source != DamageSource.field_76380_i) {
                int potionAmplifier = (player.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 1) * 5;
                damage = damage * (25.0f - (float)potionAmplifier) / 25.0f;
            }
            if (damage <= 0.0f) {
                damage = 0.0f;
            } else {
                int enchantmentModifierDamage = EnchantmentHelper.func_77508_a((Iterable)armorStacks, (DamageSource)source);
                if (enchantmentModifierDamage > 0) {
                    damage = CombatRules.func_188401_b((float)damage, (float)enchantmentModifierDamage);
                }
            }
        }
        float totalDamage = damage;
        damage = Math.max(damage - player.func_110139_bj(), 0.0f);
        player.func_110149_m(player.func_110139_bj() - (totalDamage - damage));
        damage = ForgeHooks.onLivingDamage((EntityLivingBase)player, (DamageSource)source, (float)damage);
        if (damage != 0.0f) {
            float playerHealth = player.func_110143_aJ();
            player.func_71020_j(source.func_76345_d());
            player.func_70606_j(playerHealth - damage);
            player.func_110142_aN().func_94547_a(source, playerHealth, damage);
            if (damage < 3.4028235E37f) {
                player.func_71064_a(StatList.field_188112_z, Math.round(damage * 10.0f));
            }
        }
        for (i = 0; i < armorStacks.size(); ++i) {
            armorStack = (ItemStack)armorStacks.get(i);
            if (armorStack.func_190926_b() || UnbreakingHandler.isItemConsideredBroken(armorStack) || armorStack.func_77958_k() != armorStack.func_77952_i()) continue;
            UnbreakingHandler.breakItem((EntityLivingBase)player, armorStack);
            armorStacks.set(i, (Object)ItemStack.field_190927_a);
        }
        for (i = 0; i < brokenArmorStacks.size(); ++i) {
            armorStack = (ItemStack)brokenArmorStacks.set(i, (Object)ItemStack.field_190927_a);
            if (armorStack.func_190926_b()) continue;
            UnbreakingHandler.breakItem((EntityLivingBase)player, armorStack);
            armorStacks.set(i, (Object)armorStack);
        }
    }

    private static boolean isItemConsideredBroken(ItemStack stack) {
        boolean isConsideredBroken;
        int usesRemaining = stack.func_77958_k() - stack.func_77952_i();
        boolean canBeBroken = !stack.func_190926_b() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack) > 0;
        boolean bl = isConsideredBroken = canBeBroken && usesRemaining <= 1;
        if (usesRemaining == 0 && canBeBroken) {
            stack.func_77964_b(stack.func_77958_k() - 1);
        }
        return isConsideredBroken;
    }
}

