/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant.inventory;

import java.util.List;
import java.util.Random;
import logictechcorp.libraryex.utility.RandomHelper;
import logictechcorp.reagenchant.Reagenchant;
import logictechcorp.reagenchant.inventory.ContainerReagentTable;
import logictechcorp.reagenchant.reagent.Reagent;
import logictechcorp.reagenchant.tileentity.TileEntityReagentTable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemStackHandler;

public class ReagentTableManager {
    private final World world;
    private final BlockPos pos;
    private final TileEntityReagentTable reagentTable;
    private final ItemStackHandler inventory;
    private final Random random;
    private int xpSeed;
    private int[] enchantmentHints;
    private int[] enchantmentLevels;
    private int[] enchantabilityLevels;
    private int[] reagentCosts;

    public ReagentTableManager(World world, BlockPos pos, TileEntityReagentTable reagentTable) {
        this.world = world;
        this.pos = pos;
        this.reagentTable = reagentTable;
        this.inventory = reagentTable.getInventory();
        this.random = reagentTable.getRandom();
        this.xpSeed = reagentTable.getUser().func_175138_ci();
        this.enchantmentHints = new int[]{-1, -1, -1};
        this.enchantmentLevels = new int[]{-1, -1, -1};
        this.enchantabilityLevels = new int[3];
        this.reagentCosts = new int[3];
    }

    void onContentsChanged(ContainerReagentTable containerReagentTable) {
        ItemStack unenchantedStack = this.inventory.getStackInSlot(0);
        if (unenchantedStack.func_77956_u() && !this.inventory.getStackInSlot(1).func_190926_b()) {
            if (!this.world.field_72995_K) {
                int enchantmentTier;
                float power = 0.0f;
                for (int z = -1; z <= 1; ++z) {
                    for (int x = -1; x <= 1; ++x) {
                        if (z == 0 && x == 0 || this.world.func_180495_p(this.pos.func_177982_a(x, 0, z)).func_185914_p() || this.world.func_180495_p(this.pos.func_177982_a(x, 1, z)).func_185914_p()) continue;
                        power += ForgeHooks.getEnchantPower((World)this.world, (BlockPos)this.pos.func_177982_a(x * 2, 0, z * 2));
                        power += ForgeHooks.getEnchantPower((World)this.world, (BlockPos)this.pos.func_177982_a(x * 2, 1, z * 2));
                        if (x == 0 || z == 0) continue;
                        power += ForgeHooks.getEnchantPower((World)this.world, (BlockPos)this.pos.func_177982_a(x * 2, 0, z));
                        power += ForgeHooks.getEnchantPower((World)this.world, (BlockPos)this.pos.func_177982_a(x * 2, 1, z));
                        power += ForgeHooks.getEnchantPower((World)this.world, (BlockPos)this.pos.func_177982_a(x, 0, z * 2));
                        power += ForgeHooks.getEnchantPower((World)this.world, (BlockPos)this.pos.func_177982_a(x, 1, z * 2));
                    }
                }
                this.random.setSeed(this.xpSeed);
                for (enchantmentTier = 0; enchantmentTier < 3; ++enchantmentTier) {
                    this.enchantmentHints[enchantmentTier] = -1;
                    this.enchantmentLevels[enchantmentTier] = -1;
                    this.enchantabilityLevels[enchantmentTier] = EnchantmentHelper.func_77514_a((Random)this.random, (int)enchantmentTier, (int)((int)power), (ItemStack)unenchantedStack);
                    if (this.enchantabilityLevels[enchantmentTier] < enchantmentTier + 1) {
                        this.enchantabilityLevels[enchantmentTier] = 0;
                    }
                    this.enchantabilityLevels[enchantmentTier] = ForgeEventFactory.onEnchantmentLevelSet((World)this.world, (BlockPos)this.pos, (int)enchantmentTier, (int)((int)power), (ItemStack)unenchantedStack, (int)this.enchantabilityLevels[enchantmentTier]);
                    this.reagentCosts[enchantmentTier] = 0;
                }
                for (enchantmentTier = 0; enchantmentTier < 3; ++enchantmentTier) {
                    List<EnchantmentData> enchantments;
                    if (this.enchantabilityLevels[enchantmentTier] <= 0 || (enchantments = this.createEnchantmentList(enchantmentTier)) == null || enchantments.isEmpty()) continue;
                    EnchantmentData enchantmentData = enchantments.get(this.random.nextInt(enchantments.size()));
                    this.enchantmentHints[enchantmentTier] = Enchantment.func_185258_b((Enchantment)enchantmentData.field_76302_b);
                    this.enchantmentLevels[enchantmentTier] = enchantmentData.field_76303_c;
                    ItemStack reagentStack = this.inventory.getStackInSlot(2);
                    int reagentCost = 0;
                    if (!reagentStack.func_190926_b()) {
                        EntityPlayer player = this.reagentTable.getUser();
                        Reagent reagent = Reagenchant.REAGENT_MANAGER.getReagent(reagentStack.func_77973_b());
                        for (Enchantment enchantment : reagent.getReagentEnchantmentData()) {
                            if (!enchantment.func_92089_a(unenchantedStack)) continue;
                            reagentCost += reagent.getReagentCost(this.world, this.pos, player, unenchantedStack, reagentStack, new EnchantmentData(enchantment, reagent.getEnchantmentLevel(enchantment, enchantmentTier, this.enchantabilityLevels[enchantmentTier], this.random)), this.random);
                        }
                    }
                    this.reagentCosts[enchantmentTier] = reagentCost;
                }
                containerReagentTable.func_75142_b();
            }
        } else {
            for (int enchantmentTier = 0; enchantmentTier < 3; ++enchantmentTier) {
                this.enchantmentHints[enchantmentTier] = -1;
                this.enchantmentLevels[enchantmentTier] = -1;
                this.enchantabilityLevels[enchantmentTier] = 0;
                this.reagentCosts[enchantmentTier] = 0;
            }
        }
    }

    private List<EnchantmentData> createEnchantmentList(int enchantmentTier) {
        Reagent reagent;
        ItemStack unenchantedStack = this.inventory.getStackInSlot(0);
        ItemStack reagentStack = this.inventory.getStackInSlot(2);
        int enchantabilityLevel = this.enchantabilityLevels[enchantmentTier];
        this.random.setSeed(this.xpSeed + enchantmentTier);
        List<EnchantmentData> enchantments = EnchantmentHelper.func_77513_b((Random)this.random, (ItemStack)unenchantedStack, (int)enchantabilityLevel, (boolean)false);
        boolean usedReagentEnchantments = false;
        if (!reagentStack.func_190926_b() && (reagent = Reagenchant.REAGENT_MANAGER.getReagent(reagentStack.func_77973_b())).hasApplicableEnchantments(this.world, this.pos, this.reagentTable.getUser(), unenchantedStack, reagentStack, this.random)) {
            enchantments = reagent.createEnchantmentList(this.world, this.pos, this.reagentTable.getUser(), unenchantedStack, reagentStack, enchantmentTier, enchantabilityLevel, this.random);
            usedReagentEnchantments = true;
        }
        if (unenchantedStack.func_77973_b() == Items.field_151122_aG && enchantments.size() > 1) {
            if (usedReagentEnchantments) {
                enchantments.remove(RandomHelper.getNumberInRange((int)1, (int)(enchantments.size() - 1), (Random)this.random));
            } else {
                enchantments.remove(this.random.nextInt(enchantments.size()));
            }
        }
        return enchantments;
    }

    boolean enchantItem(EntityPlayer player, int enchantmentTier, ContainerReagentTable containerReagentTable) {
        ItemStack unenchantedStack = this.inventory.getStackInSlot(0);
        ItemStack lapisStack = this.inventory.getStackInSlot(1);
        ItemStack reagentStack = this.inventory.getStackInSlot(2);
        int i = enchantmentTier + 1;
        if ((lapisStack.func_190926_b() || lapisStack.func_190916_E() < i) && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (this.enchantabilityLevels[enchantmentTier] > 0 && !unenchantedStack.func_190926_b() && (player.field_71068_ca >= i && player.field_71068_ca >= this.enchantabilityLevels[enchantmentTier] || player.field_71075_bZ.field_75098_d)) {
            List<EnchantmentData> enchantments;
            if (!this.world.field_72995_K && !(enchantments = this.createEnchantmentList(enchantmentTier)).isEmpty()) {
                boolean itemIsBook;
                ItemStack unenchantedStackCopy = unenchantedStack.func_77946_l();
                boolean bl = itemIsBook = unenchantedStack.func_77973_b() == Items.field_151122_aG;
                if (itemIsBook) {
                    unenchantedStack = new ItemStack(Items.field_151134_bR);
                    this.inventory.setStackInSlot(0, unenchantedStack);
                }
                Reagent reagent = null;
                if (!reagentStack.func_190926_b()) {
                    reagent = Reagenchant.REAGENT_MANAGER.getReagent(reagentStack.func_77973_b());
                }
                int reagentCost = 0;
                for (EnchantmentData enchantmentData : enchantments) {
                    if (EnchantmentHelper.func_82781_a((ItemStack)unenchantedStack).keySet().contains(enchantmentData.field_76302_b)) continue;
                    if (reagent != null) {
                        reagentCost = this.reagentCosts[enchantmentTier];
                        if (itemIsBook) {
                            if (reagentCost > reagentStack.func_190916_E()) {
                                return false;
                            }
                            ItemEnchantedBook.func_92115_a((ItemStack)unenchantedStack, (EnchantmentData)enchantmentData);
                            continue;
                        }
                        if (reagentCost > reagentStack.func_190916_E()) {
                            return false;
                        }
                        unenchantedStack.func_77966_a(enchantmentData.field_76302_b, enchantmentData.field_76303_c);
                        continue;
                    }
                    if (itemIsBook) {
                        ItemEnchantedBook.func_92115_a((ItemStack)unenchantedStack, (EnchantmentData)enchantmentData);
                        continue;
                    }
                    unenchantedStack.func_77966_a(enchantmentData.field_76302_b, enchantmentData.field_76303_c);
                }
                player.func_192024_a(unenchantedStack, i);
                if (!player.field_71075_bZ.field_75098_d) {
                    lapisStack.func_190918_g(i);
                    if (lapisStack.func_190926_b()) {
                        this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
                    }
                    if (reagent != null && reagent.consumeReagent(this.world, this.pos, player, itemIsBook ? unenchantedStackCopy : unenchantedStack, reagentStack, enchantments, this.random)) {
                        reagentStack.func_190918_g(reagentCost);
                        if (reagentStack.func_190926_b()) {
                            this.inventory.setStackInSlot(2, ItemStack.field_190927_a);
                        }
                    }
                }
                player.func_71029_a(StatList.field_188091_Y);
                if (player instanceof EntityPlayerMP) {
                    CriteriaTriggers.field_192129_i.func_192190_a((EntityPlayerMP)player, unenchantedStack, i);
                }
                this.reagentTable.func_70296_d();
                this.xpSeed = player.func_175138_ci();
                this.onContentsChanged(containerReagentTable);
                this.world.func_184133_a(null, this.pos, SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, this.world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            return true;
        }
        return false;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public TileEntityReagentTable getReagentTable() {
        return this.reagentTable;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public Random getRandom() {
        return this.random;
    }

    public int getXpSeed() {
        return this.xpSeed;
    }

    public int[] getEnchantmentHints() {
        return this.enchantmentHints;
    }

    public int[] getEnchantmentLevels() {
        return this.enchantmentLevels;
    }

    public int[] getEnchantabilityLevels() {
        return this.enchantabilityLevels;
    }

    public int[] getReagentCosts() {
        return this.reagentCosts;
    }

    public int getLapisAmount() {
        ItemStack lapisStack = this.inventory.getStackInSlot(1);
        return lapisStack.func_190926_b() ? 0 : lapisStack.func_190916_E();
    }

    public int getReagentAmount() {
        ItemStack reagentStack = this.inventory.getStackInSlot(2);
        return reagentStack.func_190926_b() ? 0 : reagentStack.func_190916_E();
    }

    void setXpSeed(int xpSeed) {
        this.xpSeed = xpSeed;
    }
}

