/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant.reagent;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.json.JsonFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import logictechcorp.libraryex.utility.RandomHelper;
import logictechcorp.reagenchant.reagent.ReagentEnchantmentData;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Reagent {
    protected final Item item;
    protected final Map<ResourceLocation, ReagentEnchantmentData> reagentEnchantmentData;

    public Reagent(Item item) {
        this.item = item != null ? item : Items.field_190931_a;
        this.reagentEnchantmentData = new HashMap<ResourceLocation, ReagentEnchantmentData>();
    }

    public Reagent(ResourceLocation itemRegistryName) {
        this((Item)ForgeRegistries.ITEMS.getValue(itemRegistryName));
    }

    public void addReagentEnchantmentData(ReagentEnchantmentData reagentEnchantmentData) {
        this.reagentEnchantmentData.put(reagentEnchantmentData.getEnchantment().getRegistryName(), reagentEnchantmentData);
    }

    public void removeReagentEnchantmentData(Enchantment enchantment) {
        this.reagentEnchantmentData.remove(enchantment.getRegistryName());
    }

    public void readFromConfig(Config config) {
        this.reagentEnchantmentData.clear();
        List enchantmentConfigs = (List)config.getOrElse("enchantments", new ArrayList());
        for (Config enchantmentConfig : enchantmentConfigs) {
            Enchantment enchantment = Enchantment.func_180305_b((String)((String)enchantmentConfig.getOrElse("enchantment", (Object)"")));
            if (enchantment == null) continue;
            double probability = (Double)enchantmentConfig.getOrElse("probability", (Object)0.5);
            int reagentCost = (Integer)enchantmentConfig.getOrElse("reagentCost", (Object)1);
            if (probability <= 0.0) {
                probability = 0.5;
            }
            if (reagentCost < 0) {
                reagentCost = 1;
            }
            int minimumEnchantmentLevel = (Integer)enchantmentConfig.getOrElse("minimumEnchantmentLevel", (Object)enchantment.func_77319_d());
            int maximumEnchantmentLevel = (Integer)enchantmentConfig.getOrElse("maximumEnchantmentLevel", (Object)enchantment.func_77325_b());
            if (minimumEnchantmentLevel < 1) {
                minimumEnchantmentLevel = 1;
            }
            if (maximumEnchantmentLevel > 100) {
                maximumEnchantmentLevel = 100;
            }
            this.addReagentEnchantmentData(new ReagentEnchantmentData(enchantment, minimumEnchantmentLevel, maximumEnchantmentLevel, probability, reagentCost));
        }
    }

    public void writeToConfig(Config config) {
        ArrayList<Config> enchantmentConfigs = new ArrayList<Config>();
        config.set("item", (Object)this.item.getRegistryName().toString());
        for (Map.Entry<ResourceLocation, ReagentEnchantmentData> entry : this.reagentEnchantmentData.entrySet()) {
            ReagentEnchantmentData reagenchantmentData = entry.getValue();
            Config enchantmentConfig = JsonFormat.newConfig(LinkedHashMap::new);
            enchantmentConfig.add("enchantment", (Object)entry.getKey().toString());
            enchantmentConfig.add("probability", (Object)reagenchantmentData.getEnchantmentProbability());
            enchantmentConfig.add("reagentCost", (Object)reagenchantmentData.getReagentCost());
            enchantmentConfig.add("minimumEnchantmentLevel", (Object)reagenchantmentData.getMinimumEnchantmentLevel());
            enchantmentConfig.add("maximumEnchantmentLevel", (Object)reagenchantmentData.getMaximumEnchantmentLevel());
            enchantmentConfigs.add(enchantmentConfig);
        }
        config.set("enchantments", enchantmentConfigs);
    }

    public List<EnchantmentData> createEnchantmentList(World world, BlockPos pos, EntityPlayer player, ItemStack unenchantedStack, ItemStack reagentStack, int enchantmentTier, int enchantabilityLevel, Random random) {
        int itemEnchantability = unenchantedStack.func_77973_b().getItemEnchantability(unenchantedStack);
        if (itemEnchantability <= 0) {
            return new ArrayList<EnchantmentData>();
        }
        enchantabilityLevel = enchantabilityLevel + 1 + random.nextInt(itemEnchantability / 4 + 1) + random.nextInt(itemEnchantability / 4 + 1);
        float enchantmentMultiplier = (random.nextFloat() + random.nextFloat() - 1.0f) * 0.15f;
        enchantabilityLevel = MathHelper.func_76125_a((int)Math.round((float)enchantabilityLevel + (float)enchantabilityLevel * enchantmentMultiplier), (int)1, (int)Integer.MAX_VALUE);
        ArrayList<EnchantmentData> aggregateEnchantmentData = new ArrayList<EnchantmentData>();
        List<Enchantment> applicableEnchantments = this.getApplicableEnchantments(world, pos, player, unenchantedStack, reagentStack, random);
        Collections.shuffle(applicableEnchantments, random);
        for (Enchantment enchantment : applicableEnchantments) {
            EnchantmentData enchantmentData;
            int enchantmentLevel = this.getEnchantmentLevel(enchantment, enchantmentTier, enchantabilityLevel, random);
            if (enchantmentLevel <= 0 || !(this.getEnchantmentProbability(world, pos, player, unenchantedStack, reagentStack, enchantmentData = new EnchantmentData(enchantment, enchantmentLevel), random) >= random.nextDouble())) continue;
            aggregateEnchantmentData.add(enchantmentData);
        }
        boolean addedOtherEnchantments = false;
        if (aggregateEnchantmentData.isEmpty()) {
            aggregateEnchantmentData.addAll(EnchantmentHelper.func_185291_a((int)enchantabilityLevel, (ItemStack)unenchantedStack, (boolean)false));
            addedOtherEnchantments = true;
        }
        ArrayList<EnchantmentData> refinedEnchantmentData = new ArrayList<EnchantmentData>();
        refinedEnchantmentData.add((EnchantmentData)WeightedRandom.func_76271_a((Random)random, aggregateEnchantmentData));
        if (!addedOtherEnchantments) {
            aggregateEnchantmentData.addAll(EnchantmentHelper.func_185291_a((int)enchantabilityLevel, (ItemStack)unenchantedStack, (boolean)false));
        }
        while (random.nextInt(50) <= enchantabilityLevel) {
            EnchantmentHelper.func_185282_a(aggregateEnchantmentData, (EnchantmentData)((EnchantmentData)refinedEnchantmentData.get(0)));
            if (aggregateEnchantmentData.isEmpty()) break;
            refinedEnchantmentData.add((EnchantmentData)WeightedRandom.func_76271_a((Random)random, aggregateEnchantmentData));
            enchantabilityLevel /= 2;
        }
        return refinedEnchantmentData;
    }

    public boolean hasApplicableEnchantments(World world, BlockPos pos, EntityPlayer player, ItemStack unenchantedStack, ItemStack reagentStack, Random random) {
        for (Enchantment enchantment : this.getReagentEnchantmentData()) {
            if (!enchantment.canApplyAtEnchantingTable(unenchantedStack) && (unenchantedStack.func_77973_b() != Items.field_151122_aG || !enchantment.isAllowedOnBooks())) continue;
            return true;
        }
        return false;
    }

    public boolean consumeReagent(World world, BlockPos pos, EntityPlayer player, ItemStack unenchantedStack, ItemStack reagentStack, List<EnchantmentData> enchantmentList, Random random) {
        return true;
    }

    public Item getItem() {
        return this.item;
    }

    public List<Enchantment> getReagentEnchantmentData() {
        ArrayList<Enchantment> associatedEnchantments = new ArrayList<Enchantment>();
        for (ResourceLocation registryName : this.reagentEnchantmentData.keySet()) {
            associatedEnchantments.add(Enchantment.func_180305_b((String)registryName.toString()));
        }
        return associatedEnchantments;
    }

    public List<Enchantment> getApplicableEnchantments(World world, BlockPos pos, EntityPlayer player, ItemStack unenchantedStack, ItemStack reagentStack, Random random) {
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        for (Enchantment enchantment : this.getReagentEnchantmentData()) {
            if (!enchantment.canApplyAtEnchantingTable(unenchantedStack) && (unenchantedStack.func_77973_b() != Items.field_151122_aG || !enchantment.isAllowedOnBooks())) continue;
            enchantments.add(enchantment);
        }
        return enchantments;
    }

    public ReagentEnchantmentData getReagentEnchantmentData(Enchantment enchantment) {
        return this.reagentEnchantmentData.get(enchantment.getRegistryName());
    }

    public int getEnchantmentLevel(Enchantment enchantment, int enchantmentTier, int enchantabilityLevel, Random random) {
        int enchantmentLevel;
        ReagentEnchantmentData reagentEnchantmentData = this.reagentEnchantmentData.get(enchantment.getRegistryName());
        int minimumEnchantmentLevel = reagentEnchantmentData.getMinimumEnchantmentLevel();
        int maximumEnchantmentLevel = reagentEnchantmentData.getMaximumEnchantmentLevel();
        if (minimumEnchantmentLevel == enchantment.func_77319_d() && maximumEnchantmentLevel == enchantment.func_77325_b()) {
            for (enchantmentLevel = maximumEnchantmentLevel; enchantmentLevel > minimumEnchantmentLevel - 1 && (enchantabilityLevel < enchantment.func_77321_a(enchantmentLevel) || enchantabilityLevel > enchantment.func_77317_b(enchantmentLevel)); --enchantmentLevel) {
            }
        } else {
            int oneThird = (maximumEnchantmentLevel - minimumEnchantmentLevel) / 3;
            if (enchantmentTier == 0) {
                maximumEnchantmentLevel = minimumEnchantmentLevel + oneThird;
            } else if (enchantmentTier == 1) {
                minimumEnchantmentLevel += oneThird;
                maximumEnchantmentLevel -= oneThird;
            } else {
                minimumEnchantmentLevel = maximumEnchantmentLevel - oneThird;
            }
            enchantmentLevel = RandomHelper.getNumberInRange((int)minimumEnchantmentLevel, (int)maximumEnchantmentLevel, (Random)random);
        }
        return enchantmentLevel;
    }

    public double getEnchantmentProbability(World world, BlockPos pos, EntityPlayer player, ItemStack unenchantedStack, ItemStack reagentStack, EnchantmentData enchantmentData, Random random) {
        ResourceLocation enchantmentRegistryName = enchantmentData.field_76302_b.getRegistryName();
        if (this.reagentEnchantmentData.containsKey(enchantmentRegistryName)) {
            return this.reagentEnchantmentData.get(enchantmentRegistryName).getEnchantmentProbability();
        }
        return 0.5;
    }

    public int getReagentCost(World world, BlockPos pos, EntityPlayer player, ItemStack unenchantedStack, ItemStack reagentStack, EnchantmentData enchantmentData, Random random) {
        ResourceLocation enchantmentRegistryName = enchantmentData.field_76302_b.getRegistryName();
        if (this.reagentEnchantmentData.containsKey(enchantmentRegistryName)) {
            return this.reagentEnchantmentData.get(enchantmentRegistryName).getReagentCost();
        }
        return 1;
    }
}

