/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant.reagent;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.json.JsonFormat;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import logictechcorp.libraryex.utility.FileHelper;
import logictechcorp.libraryex.utility.WorldHelper;
import logictechcorp.reagenchant.reagent.Reagent;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ReagentManager {
    private final String modId;
    private final Logger logger;
    private final Map<ResourceLocation, Reagent> defaultReagents;
    private final Map<ResourceLocation, Reagent> worldSpecificReagents;

    public ReagentManager(String modId, String modName) {
        this.modId = modId;
        this.logger = LogManager.getLogger((String)modName);
        this.defaultReagents = new HashMap<ResourceLocation, Reagent>();
        this.worldSpecificReagents = new HashMap<ResourceLocation, Reagent>();
    }

    public void setup() {
        this.worldSpecificReagents.forEach(this.defaultReagents::put);
    }

    public void registerReagent(Reagent reagent) {
        Item item;
        ResourceLocation itemRegistryName;
        if (reagent != null && !this.worldSpecificReagents.containsKey(itemRegistryName = (item = reagent.getItem()).getRegistryName()) && item != Items.field_190931_a) {
            this.worldSpecificReagents.put(item.getRegistryName(), reagent);
        }
    }

    public void unregisterReagent(Item item) {
        this.worldSpecificReagents.remove(item.getRegistryName());
    }

    public void cleanup() {
        this.worldSpecificReagents.clear();
    }

    public void readReagentConfigs(WorldEvent.Load event) {
        this.logger.info("Reading Reagent configs.");
        Path path = new File(WorldHelper.getSaveDirectory((World)event.getWorld()), "/config/" + this.modId + "/reagents/").toPath();
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            Iterator pathIter = Files.walk(path, new FileVisitOption[0]).iterator();
            while (pathIter.hasNext()) {
                File configFile = ((Path)pathIter.next()).toFile();
                if (FileHelper.getFileExtension((File)configFile).equals("json")) {
                    FileConfig config = FileConfig.builder((File)configFile, (ConfigFormat)JsonFormat.fancyInstance()).preserveInsertionOrder().build();
                    config.load();
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)config.getOrElse("item", (Object)"missing:no")));
                    if (item != null && item != Items.field_190931_a) {
                        Reagent reagent = this.hasReagent(item) ? this.getReagent(item) : new Reagent(item);
                        reagent.readFromConfig((Config)config);
                        this.registerReagent(reagent);
                    }
                    config.save();
                    config.close();
                    continue;
                }
                if (configFile.isDirectory()) continue;
                this.logger.info("Skipping file located at, {}, as it is not a json file.", (Object)configFile.getPath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createReagentConfigs(WorldEvent.Load event) {
        this.logger.info("Creating Reagent configs.");
        try {
            for (Reagent reagent : this.getDefaultReagents().values()) {
                File configFile = new File(WorldHelper.getSaveDirectory((World)event.getWorld()), "config/" + this.modId + "/reagents/" + reagent.getItem().getRegistryName().toString().replace(":", "/") + ".json");
                if (configFile.exists()) continue;
                Files.createDirectories(configFile.getParentFile().toPath(), new FileAttribute[0]);
                FileConfig config = FileConfig.builder((File)configFile, (ConfigFormat)JsonFormat.fancyInstance()).preserveInsertionOrder().build();
                reagent.writeToConfig((Config)config);
                config.save();
                config.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasReagent(Item item) {
        return this.worldSpecificReagents.containsKey(item.getRegistryName());
    }

    public Reagent getReagent(Item item) {
        return this.worldSpecificReagents.get(item.getRegistryName());
    }

    public Map<ResourceLocation, Reagent> getDefaultReagents() {
        return Collections.unmodifiableMap(this.defaultReagents);
    }

    public Map<ResourceLocation, Reagent> getWorldSpecificReagents() {
        return Collections.unmodifiableMap(this.worldSpecificReagents);
    }
}

