/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant.tileentity;

import logictechcorp.libraryex.tileentity.TileEntityInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityReagentTable
extends TileEntityInventory
implements ITickable {
    private EntityPlayer user;
    private String customName;
    private int tickCounter;
    private float pageFlip;
    private float pageFlipPrev;
    private float flipRandom;
    private float flipTurn;
    private float bookSpread;
    private float bookSpreadPrev;
    private float bookRotation;
    private float bookRotationPrev;
    private float offsetRotation;

    public TileEntityReagentTable() {
        super(3);
    }

    public boolean acceptsItemStack(ItemStack stack) {
        return true;
    }

    public void func_73660_a() {
        float rotation;
        this.bookSpreadPrev = this.bookSpread;
        this.bookRotationPrev = this.bookRotation;
        EntityPlayer playerToFace = this.user != null ? this.user : this.field_145850_b.func_184137_a((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), 3.0, false);
        if (playerToFace != null) {
            double posX = playerToFace.field_70165_t - (double)((float)this.field_174879_c.func_177958_n() + 0.5f);
            double posZ = playerToFace.field_70161_v - (double)((float)this.field_174879_c.func_177952_p() + 0.5f);
            this.offsetRotation = (float)MathHelper.func_181159_b((double)posZ, (double)posX);
            this.bookSpread += 0.1f;
            if (this.bookSpread < 0.5f || this.random.nextInt(40) == 0) {
                float randomFlip = this.flipRandom;
                do {
                    this.flipRandom += (float)(this.random.nextInt(4) - this.random.nextInt(4));
                } while (randomFlip == this.flipRandom);
            }
        } else {
            this.offsetRotation += 0.02f;
            this.bookSpread -= 0.1f;
        }
        while (this.bookRotation >= (float)Math.PI) {
            this.bookRotation -= (float)Math.PI * 2;
        }
        while (this.bookRotation < (float)(-Math.PI)) {
            this.bookRotation += (float)Math.PI * 2;
        }
        while (this.offsetRotation >= (float)Math.PI) {
            this.offsetRotation -= (float)Math.PI * 2;
        }
        while (this.offsetRotation < (float)(-Math.PI)) {
            this.offsetRotation += (float)Math.PI * 2;
        }
        for (rotation = this.offsetRotation - this.bookRotation; rotation >= (float)Math.PI; rotation -= (float)Math.PI * 2) {
        }
        while (rotation < (float)(-Math.PI)) {
            rotation += (float)Math.PI * 2;
        }
        this.bookRotation += rotation * 0.4f;
        this.bookSpread = MathHelper.func_76131_a((float)this.bookSpread, (float)0.0f, (float)1.0f);
        ++this.tickCounter;
        this.pageFlipPrev = this.pageFlip;
        float flip = (this.flipRandom - this.pageFlip) * 0.4f;
        flip = MathHelper.func_76131_a((float)flip, (float)-0.2f, (float)0.2f);
        this.flipTurn += (flip - this.flipTurn) * 0.9f;
        this.pageFlip += this.flipTurn;
    }

    private boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.hasCustomName()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public EntityPlayer getUser() {
        return this.user;
    }

    private String getName() {
        return this.hasCustomName() ? this.customName : "container.enchant";
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public float getPageFlip() {
        return this.pageFlip;
    }

    public float getPageFlipPrev() {
        return this.pageFlipPrev;
    }

    public float getBookSpread() {
        return this.bookSpread;
    }

    public float getBookSpreadPrev() {
        return this.bookSpreadPrev;
    }

    public float getBookRotation() {
        return this.bookRotation;
    }

    public float getBookRotationPrev() {
        return this.bookRotationPrev;
    }

    public void setUser(EntityPlayer player) {
        if (this.user == null) {
            this.user = player;
        } else if (player == null) {
            this.user = null;
        }
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }
}

