/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant.block;

import java.util.Random;
import logictechcorp.libraryex.block.TileEntityBlock;
import logictechcorp.reagenchant.inventory.container.ReagentTableContainer;
import logictechcorp.reagenchant.tileentity.ReagentTableTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tileentity.EnchantingTableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ReagentTableBlock
extends TileEntityBlock<ReagentTableTileEntity> {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public ReagentTableBlock(Block.Properties properties) {
        super(properties, ReagentTableTileEntity.class);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        for (int x = -2; x <= 2; ++x) {
            block1: for (int z = -2; z <= 2; ++z) {
                if (x > -2 && x < 2 && z == -1) {
                    z = 2;
                }
                if (rand.nextInt(16) != 0) continue;
                for (int y = 0; y <= 1; ++y) {
                    BlockPos adjustedPos = pos.func_177982_a(x, y, z);
                    if (!(world.func_180495_p(adjustedPos).getEnchantPowerBonus((IWorldReader)world, pos) > 0.0f)) continue;
                    if (!world.func_175623_d(pos.func_177982_a(x / 2, 0, z / 2))) continue block1;
                    world.func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.0, (double)pos.func_177952_p() + 0.5, (double)((float)x + rand.nextFloat()) - 0.5, (double)((float)y - rand.nextFloat() - 1.0f), (double)((float)z + rand.nextFloat()) - 0.5);
                }
            }
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileEntity;
        if (stack.func_82837_s() && (tileEntity = world.func_175625_s(pos)) instanceof ReagentTableTileEntity) {
            ((ReagentTableTileEntity)tileEntity).setCustomName(stack.func_200301_q());
        }
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (!world.field_72995_K) {
            if (world.func_175625_s(pos) instanceof EnchantingTableTileEntity) {
                world.func_175690_a(pos, this.createTileEntity(state, (IBlockReader)world));
            }
            player.func_213829_a(state.func_215699_b(world, pos));
            Container openContainer = player.field_71070_bA;
            if (openContainer instanceof ReagentTableContainer) {
                ((ReagentTableContainer)openContainer).onContentsChanged();
            }
        }
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return false;
    }

    public boolean func_220074_n(BlockState p_220074_1_) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public INamedContainerProvider func_220052_b(BlockState state, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ReagentTableTileEntity) {
            ReagentTableTileEntity reagentTable = (ReagentTableTileEntity)tileEntity;
            return new SimpleNamedContainerProvider((id, playerInventory, player) -> new ReagentTableContainer(id, playerInventory, reagentTable.getItemStackHandler(), IWorldPosCallable.func_221488_a((World)world, (BlockPos)pos)), reagentTable.func_145748_c_());
        }
        return null;
    }
}

