/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant.client.gui.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import logictechcorp.reagenchant.Reagenchant;
import logictechcorp.reagenchant.inventory.container.ReagentTableContainer;
import logictechcorp.reagenchant.reagent.Reagent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.model.BookModel;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnchantmentNameParts;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ReagentTableScreen
extends ContainerScreen<ReagentTableContainer> {
    private static final ResourceLocation REAGENT_TABLE_WITH_REAGENT_GUI = new ResourceLocation("reagenchant", "textures/gui/container/reagent_table_with_reagent.png");
    private static final ResourceLocation REAGENT_TABLE_WITHOUT_REAGENT_GUI = new ResourceLocation("reagenchant", "textures/gui/container/reagent_table_without_reagent.png");
    private static final ResourceLocation REAGENT_TABLE_BOOK = new ResourceLocation("reagenchant", "textures/entity/reagent_table_book.png");
    private static final BookModel MODEL_BOOK = new BookModel();
    private final Random random;
    private float flip;
    private float flipPrev;
    private float flipRandom;
    private float flipTurn;
    private float open;
    private float openPrev;
    private ItemStack last = ItemStack.field_190927_a;

    public ReagentTableScreen(ReagentTableContainer container, PlayerInventory playerInventory, ITextComponent component) {
        super((Container)container, playerInventory, component);
        this.random = new Random();
    }

    public void tick() {
        super.tick();
        this.tickBook();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.title.func_150254_d(), 12.0f, 5.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        int width = (this.width - this.field_146999_f) / 2;
        int height = (this.height - this.field_147000_g) / 2;
        for (int enchantmentTier = 0; enchantmentTier < 3; ++enchantmentTier) {
            double posX = mouseX - (double)(width + 60);
            double posY = mouseY - (double)(height + 14 + 19 * enchantmentTier);
            if (!(posX >= 0.0) || !(posY >= 0.0) || !(posX < 108.0) || !(posY < 19.0) || !((ReagentTableContainer)this.field_147002_h).func_75140_a((PlayerEntity)this.minecraft.field_71439_g, enchantmentTier)) continue;
            this.minecraft.field_71442_b.func_78756_a(((ReagentTableContainer)this.field_147002_h).field_75152_c, enchantmentTier);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        ResourceLocation guiTexture = !((ReagentTableContainer)this.field_147002_h).getItemStackHandler().getStackInSlot(2).func_190926_b() ? REAGENT_TABLE_WITH_REAGENT_GUI : REAGENT_TABLE_WITHOUT_REAGENT_GUI;
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(guiTexture);
        int width = (this.width - this.field_146999_f) / 2;
        int height = (this.height - this.field_147000_g) / 2;
        this.blit(width, height, 0, 0, this.field_146999_f, this.field_147000_g);
        GlStateManager.pushMatrix();
        GlStateManager.matrixMode((int)5889);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        int guiScaleFactor = (int)this.minecraft.field_195558_d.func_198100_s();
        GlStateManager.viewport((int)((this.width - 320) / 2 * guiScaleFactor), (int)((this.height - 240) / 2 * guiScaleFactor), (int)(320 * guiScaleFactor), (int)(240 * guiScaleFactor));
        GlStateManager.translatef((float)-0.34f, (float)0.23f, (float)0.0f);
        GlStateManager.multMatrix((Matrix4f)Matrix4f.func_195876_a((double)90.0, (float)1.3333334f, (float)9.0f, (float)80.0f));
        GlStateManager.matrixMode((int)5888);
        GlStateManager.loadIdentity();
        RenderHelper.func_74519_b();
        GlStateManager.translatef((float)0.0f, (float)3.3f, (float)-16.0f);
        GlStateManager.scalef((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.scalef((float)5.0f, (float)5.0f, (float)5.0f);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(REAGENT_TABLE_BOOK);
        GlStateManager.rotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float openFlip = MathHelper.func_219799_g((float)partialTicks, (float)this.openPrev, (float)this.open);
        GlStateManager.translatef((float)((1.0f - openFlip) * 0.2f), (float)((1.0f - openFlip) * 0.1f), (float)((1.0f - openFlip) * 0.25f));
        GlStateManager.rotatef((float)(-(1.0f - openFlip) * 90.0f - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float pageOneFlip = MathHelper.func_219799_g((float)partialTicks, (float)this.flipPrev, (float)this.flip) + 0.25f;
        float pageTwoFlip = MathHelper.func_219799_g((float)partialTicks, (float)this.flipPrev, (float)this.flip) + 0.75f;
        pageOneFlip = (pageOneFlip - (float)MathHelper.func_76140_b((double)pageOneFlip)) * 1.6f - 0.3f;
        pageTwoFlip = (pageTwoFlip - (float)MathHelper.func_76140_b((double)pageTwoFlip)) * 1.6f - 0.3f;
        if (pageOneFlip < 0.0f) {
            pageOneFlip = 0.0f;
        }
        if (pageTwoFlip < 0.0f) {
            pageTwoFlip = 0.0f;
        }
        if (pageOneFlip > 1.0f) {
            pageOneFlip = 1.0f;
        }
        if (pageTwoFlip > 1.0f) {
            pageTwoFlip = 1.0f;
        }
        GlStateManager.enableRescaleNormal();
        MODEL_BOOK.func_217103_a(0.0f, pageOneFlip, pageTwoFlip, openFlip, 0.0f, 0.0625f);
        GlStateManager.disableRescaleNormal();
        RenderHelper.func_74518_a();
        GlStateManager.matrixMode((int)5889);
        GlStateManager.viewport((int)0, (int)0, (int)this.minecraft.field_195558_d.func_198109_k(), (int)this.minecraft.field_195558_d.func_198091_l());
        GlStateManager.popMatrix();
        GlStateManager.matrixMode((int)5888);
        GlStateManager.popMatrix();
        RenderHelper.func_74518_a();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        EnchantmentNameParts.func_178176_a().func_148335_a((long)(((ReagentTableContainer)this.field_147002_h).getXpSeed() + (((ReagentTableContainer)this.field_147002_h).getReagentAmount() == 0 ? 0 : 1)));
        for (int i = 0; i < 3; ++i) {
            int enchantabilityLevel = ((ReagentTableContainer)this.field_147002_h).getEnchantabilityLevels()[i];
            int rectanglePosX = width + 62;
            int textPosX = rectanglePosX + 20;
            this.blitOffset = 0;
            this.minecraft.func_110434_K().func_110577_a(guiTexture);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (enchantabilityLevel == 0) {
                this.blit(rectanglePosX, height + 14 + 19 * i, 0, 185, 108, 19);
                continue;
            }
            String enchantabilityLevelString = "" + enchantabilityLevel;
            int length = 86 - this.font.func_78256_a(enchantabilityLevelString);
            String randomName = EnchantmentNameParts.func_178176_a().func_148334_a(this.font, length);
            FontRenderer fontRenderer = this.minecraft.func_211500_ak().func_211504_a(Minecraft.field_71464_q);
            int color = 6839882;
            if ((((ReagentTableContainer)this.field_147002_h).getLapisAmount() < i + 1 || ((ReagentTableContainer)this.field_147002_h).getReagentAmount() < ((ReagentTableContainer)this.field_147002_h).getReagentCost()[i] || this.minecraft.field_71439_g.field_71068_ca < enchantabilityLevel) && !this.minecraft.field_71439_g.field_71075_bZ.field_75098_d || ((ReagentTableContainer)this.field_147002_h).getEnchantments()[i] == -1) {
                this.blit(rectanglePosX, height + 14 + 19 * i, 0, 185, 108, 19);
                this.blit(rectanglePosX + 1, height + 15 + 19 * i, 16 * i, 239, 16, 16);
                fontRenderer.func_78279_b(randomName, textPosX, height + 16 + 19 * i, length, (color & 0xFEFEFE) >> 1);
                color = 4226832;
            } else {
                int cursorPosX = mouseX - (width + 60);
                int cursorPosY = mouseY - (height + 14 + 19 * i);
                if (cursorPosX >= 0 && cursorPosY >= 0 && cursorPosX < 108 && cursorPosY < 19) {
                    this.blit(rectanglePosX, height + 14 + 19 * i, 0, 204, 108, 19);
                    color = 0xFFFF80;
                } else {
                    this.blit(rectanglePosX, height + 14 + 19 * i, 0, 166, 108, 19);
                }
                this.blit(rectanglePosX + 1, height + 15 + 19 * i, 16 * i, 223, 16, 16);
                fontRenderer.func_78279_b(randomName, textPosX, height + 16 + 19 * i, length, color);
                color = 8453920;
            }
            fontRenderer = this.minecraft.field_71466_p;
            fontRenderer.func_175063_a(enchantabilityLevelString, (float)(textPosX + 86 - fontRenderer.func_78256_a(enchantabilityLevelString)), (float)(height + 16 + 19 * i + 7), color);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        partialTicks = this.minecraft.func_193989_ak();
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        for (int i = 0; i < 3; ++i) {
            Enchantment enchantment = Enchantment.func_185262_c((int)((ReagentTableContainer)this.field_147002_h).getEnchantments()[i]);
            int enchantmentLevel = ((ReagentTableContainer)this.field_147002_h).getEnchantmentLevels()[i];
            int enchantabilityLevel = ((ReagentTableContainer)this.field_147002_h).getEnchantabilityLevels()[i];
            int enchantmentTier = i + 1;
            if (!this.func_195359_a(62, 14 + 19 * i, 108, 17, mouseX, mouseY) || enchantabilityLevel <= 0) continue;
            ArrayList<String> list = new ArrayList<String>();
            list.add("" + TextFormatting.WHITE + TextFormatting.ITALIC + I18n.func_135052_a((String)"container.enchant.clue", (Object[])new Object[]{enchantment == null ? "" : enchantment.func_200305_d(enchantmentLevel).func_150254_d()}));
            if (enchantment == null) {
                Collections.addAll(list, "", TextFormatting.RED + I18n.func_135052_a((String)"forge.container.enchant.limitedEnchantability", (Object[])new Object[0]));
            } else if (!this.minecraft.field_71439_g.field_71075_bZ.field_75098_d) {
                list.add("");
                if (this.minecraft.field_71439_g.field_71068_ca < enchantabilityLevel) {
                    list.add(TextFormatting.RED + I18n.func_135052_a((String)"container.enchant.level.requirement", (Object[])new Object[]{enchantabilityLevel}));
                } else {
                    int reagentCost;
                    TextFormatting lapisTextFormatting = ((ReagentTableContainer)this.field_147002_h).getLapisAmount() >= enchantmentTier ? TextFormatting.GRAY : TextFormatting.RED;
                    String lapisText = enchantmentTier == 1 ? I18n.func_135052_a((String)"container.enchant.lapis.one", (Object[])new Object[0]) : I18n.func_135052_a((String)"container.enchant.lapis.many", (Object[])new Object[]{enchantmentTier});
                    list.add(lapisTextFormatting + "" + lapisText);
                    ItemStack reagentStack = ((ReagentTableContainer)this.field_147002_h).getItemStackHandler().getStackInSlot(2);
                    Reagent reagent = Reagenchant.REAGENT_MANAGER.getReagent(reagentStack.func_77973_b());
                    if (!reagent.isEmpty() && (reagentCost = ((ReagentTableContainer)this.field_147002_h).getReagentCost()[i]) > 0) {
                        TextFormatting reagentTextFormatting = ((ReagentTableContainer)this.field_147002_h).getReagentAmount() >= reagentCost ? TextFormatting.GRAY : TextFormatting.RED;
                        String reagentText = reagentCost == 1 ? I18n.func_135052_a((String)"container.reagenchant.reagent_table.reagent.cost.one", (Object[])new Object[]{I18n.func_135052_a((String)reagentStack.func_77977_a(), (Object[])new Object[0])}) : I18n.func_135052_a((String)"container.reagenchant.reagent_table.reagent.cost.many", (Object[])new Object[]{reagentCost, I18n.func_135052_a((String)reagentStack.func_77977_a(), (Object[])new Object[0])});
                        list.add(reagentTextFormatting + "" + reagentText);
                    }
                    String enchantLevelText = enchantmentTier == 1 ? I18n.func_135052_a((String)"container.enchant.level.one", (Object[])new Object[0]) : I18n.func_135052_a((String)"container.enchant.level.many", (Object[])new Object[]{enchantmentTier});
                    list.add(TextFormatting.GRAY + "" + enchantLevelText);
                }
            }
            this.renderTooltip(list, mouseX, mouseY);
            break;
        }
    }

    private void tickBook() {
        ItemStack stack = ((ReagentTableContainer)this.field_147002_h).func_75139_a(0).func_75211_c();
        if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.last)) {
            this.last = stack;
            do {
                this.flipRandom += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            } while (!(this.flip > this.flipRandom + 1.0f) && !(this.flip < this.flipRandom - 1.0f));
        }
        this.flipPrev = this.flip;
        this.openPrev = this.open;
        boolean flag = false;
        for (int i = 0; i < 3; ++i) {
            if (((ReagentTableContainer)this.field_147002_h).getEnchantabilityLevels()[i] == 0) continue;
            flag = true;
        }
        this.open = flag ? (this.open += 0.2f) : (this.open -= 0.2f);
        this.open = MathHelper.func_76131_a((float)this.open, (float)0.0f, (float)1.0f);
        float flip = (this.flipRandom - this.flip) * 0.4f;
        flip = MathHelper.func_76131_a((float)flip, (float)-0.2f, (float)0.2f);
        this.flipTurn += (flip - this.flipTurn) * 0.9f;
        this.flip += this.flipTurn;
    }
}

