/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant.client.renderer.tileentity;

import com.mojang.blaze3d.platform.GlStateManager;
import logictechcorp.reagenchant.tileentity.ReagentTableTileEntity;
import net.minecraft.client.renderer.entity.model.BookModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityReagentTableRenderer
extends TileEntityRenderer<ReagentTableTileEntity> {
    private static final ResourceLocation REAGENT_TABLE_BOOK = new ResourceLocation("reagenchant", "textures/entity/reagent_table_book.png");
    private final BookModel modelBook = new BookModel();

    public void render(ReagentTableTileEntity reagentTable, double x, double y, double z, float partialTicks, int destroyStage) {
        float bookRotation;
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        float ticks = (float)reagentTable.getTickCounter() + partialTicks;
        GlStateManager.translatef((float)0.0f, (float)(0.1f + MathHelper.func_76126_a((float)(ticks * 0.1f)) * 0.01f), (float)0.0f);
        for (bookRotation = reagentTable.getBookRotation() - reagentTable.getBookRotationPrev(); bookRotation >= (float)Math.PI; bookRotation -= (float)Math.PI * 2) {
        }
        while (bookRotation < (float)(-Math.PI)) {
            bookRotation += (float)Math.PI * 2;
        }
        float previousBookRotation = reagentTable.getBookRotationPrev() + bookRotation * partialTicks;
        GlStateManager.rotatef((float)(-previousBookRotation * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)80.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.func_147499_a(REAGENT_TABLE_BOOK);
        float pageOneFlip = reagentTable.getPageFlipPrev() + (reagentTable.getPageFlip() - reagentTable.getPageFlipPrev()) * partialTicks + 0.25f;
        float pageTwoFlip = reagentTable.getPageFlipPrev() + (reagentTable.getPageFlip() - reagentTable.getPageFlipPrev()) * partialTicks + 0.75f;
        pageOneFlip = (pageOneFlip - (float)MathHelper.func_76140_b((double)pageOneFlip)) * 1.6f - 0.3f;
        pageTwoFlip = (pageTwoFlip - (float)MathHelper.func_76140_b((double)pageTwoFlip)) * 1.6f - 0.3f;
        if (pageOneFlip < 0.0f) {
            pageOneFlip = 0.0f;
        }
        if (pageTwoFlip < 0.0f) {
            pageTwoFlip = 0.0f;
        }
        if (pageOneFlip > 1.0f) {
            pageOneFlip = 1.0f;
        }
        if (pageTwoFlip > 1.0f) {
            pageTwoFlip = 1.0f;
        }
        float bookSpread = reagentTable.getBookSpreadPrev() + (reagentTable.getBookSpread() - reagentTable.getBookSpreadPrev()) * partialTicks;
        GlStateManager.enableCull();
        this.modelBook.func_217103_a(ticks, pageOneFlip, pageTwoFlip, bookSpread, 0.0f, 0.0625f);
        GlStateManager.popMatrix();
    }
}

