/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import logictechcorp.reagenchant.Reagenchant;
import logictechcorp.reagenchant.network.item.reagent.MessageSUpdateReagentsPacket;
import logictechcorp.reagenchant.reagent.Reagent;
import logictechcorp.reagenchant.reagent.ReagentEnchantData;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EnchantmentArgument;
import net.minecraft.command.arguments.ItemArgument;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.PacketDistributor;

public class ReagentCommand {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"reagent").then(ReagentCommand.registerCreation())).then(ReagentCommand.registerDefaultAddition())).then(ReagentCommand.registerCustomAddition())).then(ReagentCommand.registerRemoval())).then(ReagentCommand.registerDeletion());
    }

    private static ArgumentBuilder<CommandSource, ?> registerCreation() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"create").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"item", (ArgumentType)ItemArgument.func_197317_a()).executes(ReagentCommand::createReagent));
    }

    private static ArgumentBuilder<CommandSource, ?> registerDefaultAddition() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"addEnchantment").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"item", (ArgumentType)ItemArgument.func_197317_a()).then(Commands.func_197056_a((String)"enchantment", (ArgumentType)EnchantmentArgument.func_201945_a()).executes(ReagentCommand::addDefaultToReagent)));
    }

    private static ArgumentBuilder<CommandSource, ?> registerCustomAddition() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"addEnchantment").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"item", (ArgumentType)ItemArgument.func_197317_a()).then(Commands.func_197056_a((String)"enchantment", (ArgumentType)EnchantmentArgument.func_201945_a()).then(Commands.func_197056_a((String)"minimum enchantment level", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.func_197056_a((String)"maximum enchantment level", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.func_197056_a((String)"probability", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).then(Commands.func_197056_a((String)"reagent cost", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ReagentCommand::addCustomToReagent)))))));
    }

    private static ArgumentBuilder<CommandSource, ?> registerRemoval() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"removeEnchantment").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"item", (ArgumentType)ItemArgument.func_197317_a()).then(Commands.func_197056_a((String)"enchantment", (ArgumentType)EnchantmentArgument.func_201945_a()).executes(ReagentCommand::removeFromReagent)));
    }

    private static ArgumentBuilder<CommandSource, ?> registerDeletion() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"delete").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"item", (ArgumentType)ItemArgument.func_197317_a()).executes(ReagentCommand::deleteReagent));
    }

    private static int createReagent(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        MinecraftServer server = source.func_197028_i();
        Item item = ItemArgument.func_197316_a(context, (String)"item").func_197319_a();
        Reagent reagent = Reagenchant.REAGENT_MANAGER.getReagent(item);
        if (reagent.isEmpty()) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.cave_upgrade.reagent.create.success", new Object[]{item.getRegistryName()}), true);
        } else {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("command.cave_upgrade.reagent.create.override", new Object[]{item.getRegistryName()}));
        }
        reagent = Reagenchant.REAGENT_MANAGER.createReagent(item);
        Reagenchant.REAGENT_MANAGER.registerReagent(reagent);
        ReagentCommand.saveReagentFile(server, reagent);
        ReagentCommand.sendClientSyncPacket(source);
        return 1;
    }

    private static int addDefaultToReagent(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        MinecraftServer server = source.func_197028_i();
        Item item = ItemArgument.func_197316_a(context, (String)"item").func_197319_a();
        if (item != Items.field_190931_a) {
            Reagent reagent = Reagenchant.REAGENT_MANAGER.getReagent(item);
            Enchantment enchantment = EnchantmentArgument.func_201944_a(context, (String)"enchantment");
            if (reagent.isEmpty()) {
                source.func_197021_a((ITextComponent)new TranslationTextComponent("command.cave_upgrade.reagent.add.error", new Object[]{item.getRegistryName()}));
                return 0;
            }
            reagent.addEnchantment(new ReagentEnchantData(enchantment, enchantment.func_77319_d(), enchantment.func_77325_b(), 0.5f, 1));
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.cave_upgrade.reagent.add.success", new Object[]{enchantment.getRegistryName(), item.getRegistryName()}), true);
            ReagentCommand.saveReagentFile(server, reagent);
            ReagentCommand.sendClientSyncPacket(source);
            return 1;
        }
        return 0;
    }

    private static int addCustomToReagent(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        MinecraftServer server = source.func_197028_i();
        Item item = ItemArgument.func_197316_a(context, (String)"item").func_197319_a();
        if (item != Items.field_190931_a) {
            Reagent reagent = Reagenchant.REAGENT_MANAGER.getReagent(item);
            Enchantment enchantment = EnchantmentArgument.func_201944_a(context, (String)"enchantment");
            int minimumLevel = IntegerArgumentType.getInteger(context, (String)"minimum enchantment level");
            int maximumLevel = IntegerArgumentType.getInteger(context, (String)"maximum enchantment level");
            float enchantmentProbability = FloatArgumentType.getFloat(context, (String)"probability");
            int reagentCost = IntegerArgumentType.getInteger(context, (String)"reagent cost");
            if (reagent.isEmpty()) {
                source.func_197021_a((ITextComponent)new TranslationTextComponent("command.cave_upgrade.reagent.add.error", new Object[]{item.getRegistryName()}));
                return 0;
            }
            reagent.addEnchantment(new ReagentEnchantData(enchantment, minimumLevel, maximumLevel, enchantmentProbability, reagentCost));
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.cave_upgrade.reagent.add.success", new Object[]{enchantment.getRegistryName(), item.getRegistryName()}), true);
            ReagentCommand.saveReagentFile(server, reagent);
            ReagentCommand.sendClientSyncPacket(source);
            return 1;
        }
        return 0;
    }

    private static int removeFromReagent(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        MinecraftServer server = source.func_197028_i();
        Item item = ItemArgument.func_197316_a(context, (String)"item").func_197319_a();
        if (item != Items.field_190931_a) {
            Enchantment enchantment = EnchantmentArgument.func_201944_a(context, (String)"enchantment");
            Reagent reagent = Reagenchant.REAGENT_MANAGER.getReagent(item);
            if (reagent.isEmpty()) {
                source.func_197021_a((ITextComponent)new TranslationTextComponent("command.cave_upgrade.reagent.remove.error", new Object[]{item.getRegistryName()}));
                return 0;
            }
            reagent.removeEnchantment(enchantment);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.cave_upgrade.reagent.remove.success", new Object[]{enchantment.getRegistryName(), item.getRegistryName()}), true);
            ReagentCommand.saveReagentFile(server, reagent);
            ReagentCommand.sendClientSyncPacket(source);
            return 1;
        }
        return 0;
    }

    private static int deleteReagent(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        MinecraftServer server = source.func_197028_i();
        Item item = ItemArgument.func_197316_a(context, (String)"item").func_197319_a();
        Reagent reagent = Reagenchant.REAGENT_MANAGER.getReagent(item);
        if (reagent.isEmpty()) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("command.cave_upgrade.reagent.delete.error", new Object[]{item.getRegistryName()}));
            return 0;
        }
        Reagenchant.REAGENT_MANAGER.unregisterReagent(reagent);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.cave_upgrade.reagent.delete.success", new Object[]{item.getRegistryName()}), true);
        ReagentCommand.deleteReagentFile(server, reagent);
        ReagentCommand.sendClientSyncPacket(source);
        return 1;
    }

    static void saveReagentFile(Path datapackDirectoryPath, String reagentPackName, Reagent reagent) {
        Path reagentPackReagentFilePath;
        Path reagentPackReagentsPath;
        block39: {
            Path reagentPackMCMetaPath;
            Path reagentPackPath = datapackDirectoryPath.resolve(reagentPackName);
            reagentPackReagentsPath = reagentPackPath.resolve(Paths.get("data", "reagenchant", "reagents"));
            if (!Files.exists(reagentPackReagentsPath, new LinkOption[0])) {
                try {
                    Files.createDirectories(reagentPackReagentsPath, new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
            if (!Files.exists(reagentPackMCMetaPath = reagentPackPath.resolve("pack.mcmeta"), new LinkOption[0])) {
                try {
                    Files.createFile(reagentPackMCMetaPath, new FileAttribute[0]);
                    if (!Files.exists(reagentPackMCMetaPath, new LinkOption[0])) break block39;
                    JsonObject jsonObject = new JsonObject();
                    JsonObject packObject = new JsonObject();
                    packObject.addProperty("description", "Custom reagent pack.");
                    packObject.addProperty("pack_format", (Number)4);
                    jsonObject.add("pack", (JsonElement)packObject);
                    try {
                        FileWriter fileWriter = new FileWriter(reagentPackMCMetaPath.toFile());
                        Object object = null;
                        try {
                            fileWriter.write(GSON.toJson((JsonElement)jsonObject));
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            if (fileWriter != null) {
                                if (object != null) {
                                    try {
                                        fileWriter.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object).addSuppressed(throwable);
                                    }
                                } else {
                                    fileWriter.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!Files.exists(reagentPackReagentFilePath = reagentPackReagentsPath.resolve(reagent.getItem().getRegistryName().func_110623_a().replace(":", "/") + ".json"), new LinkOption[0])) {
            try {
                Files.createFile(reagentPackReagentFilePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (Files.exists(reagentPackReagentFilePath, new LinkOption[0])) {
            JsonObject reagentObject = new JsonObject();
            reagentObject.addProperty("item", reagent.getItem().getRegistryName().toString());
            JsonArray enchantmentArray = new JsonArray();
            for (Enchantment enchantment : reagent.getEnchantments()) {
                JsonObject enchantmentObject = new JsonObject();
                ReagentEnchantData enchantmentData = reagent.getReagentEnchantData(enchantment);
                enchantmentObject.addProperty("enchantment", enchantment.getRegistryName().toString());
                enchantmentObject.addProperty("minimumEnchantmentLevel", (Number)enchantmentData.getMinimumEnchantmentLevel());
                enchantmentObject.addProperty("maximumEnchantmentLevel", (Number)enchantmentData.getMaximumEnchantmentLevel());
                enchantmentObject.addProperty("probability", (Number)Float.valueOf(enchantmentData.getEnchantmentProbability()));
                enchantmentObject.addProperty("reagentCost", (Number)enchantmentData.getReagentCost());
                enchantmentArray.add((JsonElement)enchantmentObject);
            }
            reagentObject.add("enchantments", (JsonElement)enchantmentArray);
            try (FileWriter fileWriter = new FileWriter(reagentPackReagentFilePath.toFile());){
                fileWriter.write(GSON.toJson((JsonElement)reagentObject));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void saveReagentFile(MinecraftServer server, Reagent reagent) {
        Path datapackDirectoryPath = server.func_71254_M().func_186352_b(server.func_71270_I(), "datapacks").toPath().toAbsolutePath().normalize();
        ReagentCommand.saveReagentFile(datapackDirectoryPath, "custom_reagent_pack", reagent);
    }

    static void deleteReagentFile(Path datapackDirectoryPath, String reagentPackName, Reagent reagent) {
        Path customReagentDirectory = datapackDirectoryPath.resolve(Paths.get(reagentPackName, "data", "reagenchant", "reagents"));
        Path customReagentFile = customReagentDirectory.resolve(reagent.getItem().getRegistryName().func_110623_a().replace(":", "/") + ".json");
        try {
            Files.deleteIfExists(customReagentFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void deleteReagentFile(MinecraftServer server, Reagent reagent) {
        Path datapackDirectoryPath = server.func_71254_M().func_186352_b(server.func_71270_I(), "datapacks").toPath().toAbsolutePath().normalize();
        ReagentCommand.deleteReagentFile(datapackDirectoryPath, "custom_reagent_pack", reagent);
    }

    private static void sendClientSyncPacket(CommandSource source) {
        try {
            ServerPlayerEntity player = source.func_197035_h();
            Reagenchant.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageSUpdateReagentsPacket(Reagenchant.REAGENT_MANAGER.getReagents().values()));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
    }
}

