/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant.inventory.container;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import logictechcorp.libraryex.utility.RandomHelper;
import logictechcorp.reagenchant.Reagenchant;
import logictechcorp.reagenchant.inventory.container.ReagenchantContainers;
import logictechcorp.reagenchant.reagent.Reagent;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ReagentTableContainer
extends Container {
    private final ItemStackHandler itemStackHandler;
    private final IWorldPosCallable worldPosCallable;
    private final Random random;
    private final IntReferenceHolder xpSeed;
    private final int[] enchantments;
    private final int[] enchantmentLevels;
    private final int[] enchantabilityLevels;
    private final int[] reagentCost;

    public ReagentTableContainer(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, new ItemStackHandler(3), IWorldPosCallable.field_221489_a);
    }

    public ReagentTableContainer(int id, PlayerInventory playerInventory, ItemStackHandler itemStackHandler, IWorldPosCallable worldPosCallable) {
        super((ContainerType)ReagenchantContainers.REAGENT_TABLE_CONTAINER.get(), id);
        this.itemStackHandler = itemStackHandler;
        this.worldPosCallable = worldPosCallable;
        this.random = new Random();
        this.xpSeed = IntReferenceHolder.func_221492_a();
        this.enchantments = new int[]{-1, -1, -1};
        this.enchantmentLevels = new int[]{-1, -1, -1};
        this.enchantabilityLevels = new int[3];
        this.reagentCost = new int[3];
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.itemStackHandler, 0, 6, 47){

            public void func_75218_e() {
                ReagentTableContainer.this.onContentsChanged();
            }

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77956_u() || stack.func_77973_b() == Items.field_151122_aG;
            }

            public int func_75219_a() {
                return 1;
            }

            public int func_178170_b(ItemStack stack) {
                return 1;
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.itemStackHandler, 1, 24, 47){

            public void func_75218_e() {
                ReagentTableContainer.this.onContentsChanged();
            }

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b().func_206844_a(Tags.Items.GEMS_LAPIS);
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.itemStackHandler, 2, 42, 47){

            public void func_75218_e() {
                ReagentTableContainer.this.onContentsChanged();
            }

            public boolean func_75214_a(ItemStack stack) {
                return Reagenchant.REAGENT_MANAGER.isReagent(stack.func_77973_b());
            }
        });
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInventory, x, 8 + x * 18, 142));
        }
        this.xpSeed.func_221494_a(playerInventory.field_70458_d.func_175138_ci());
        this.func_216958_a(this.xpSeed);
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.enchantments, (int)0));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.enchantments, (int)1));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.enchantments, (int)2));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.enchantmentLevels, (int)0));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.enchantmentLevels, (int)1));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.enchantmentLevels, (int)2));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.enchantabilityLevels, (int)0));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.enchantabilityLevels, (int)1));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.enchantabilityLevels, (int)2));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.reagentCost, (int)0));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.reagentCost, (int)1));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.reagentCost, (int)2));
    }

    public void onContentsChanged() {
        ItemStack unenchantedStack = this.itemStackHandler.getStackInSlot(0);
        if (unenchantedStack.func_77956_u() && !this.itemStackHandler.getStackInSlot(1).func_190926_b()) {
            this.worldPosCallable.func_221486_a((world, pos) -> {
                int i;
                float power = 0.0f;
                for (int z = -1; z <= 1; ++z) {
                    for (int x = -1; x <= 1; ++x) {
                        BlockPos adjustedPos = pos.func_177982_a(x, 0, z);
                        BlockPos adjustedPosUp = adjustedPos.func_177984_a();
                        if (z == 0 && x == 0 || world.func_180495_p(adjustedPos).func_200015_d((IBlockReader)world, adjustedPos) || world.func_180495_p(adjustedPosUp).func_200015_d((IBlockReader)world, adjustedPosUp)) continue;
                        power += this.getEnchantPower((World)world, pos.func_177982_a(x * 2, 0, z * 2));
                        power += this.getEnchantPower((World)world, pos.func_177982_a(x * 2, 1, z * 2));
                        if (x == 0 || z == 0) continue;
                        power += this.getEnchantPower((World)world, pos.func_177982_a(x * 2, 0, z));
                        power += this.getEnchantPower((World)world, pos.func_177982_a(x * 2, 1, z));
                        power += this.getEnchantPower((World)world, pos.func_177982_a(x, 0, z * 2));
                        power += this.getEnchantPower((World)world, pos.func_177982_a(x, 1, z * 2));
                    }
                }
                this.random.setSeed(this.xpSeed.func_221495_b());
                for (i = 0; i < 3; ++i) {
                    this.enchantments[i] = -1;
                    this.enchantmentLevels[i] = -1;
                    this.enchantabilityLevels[i] = EnchantmentHelper.func_77514_a((Random)this.random, (int)i, (int)((int)power), (ItemStack)unenchantedStack);
                    if (this.enchantabilityLevels[i] < i + 1) {
                        this.enchantabilityLevels[i] = 0;
                    }
                    this.enchantabilityLevels[i] = ForgeEventFactory.onEnchantmentLevelSet((World)world, (BlockPos)pos, (int)i, (int)((int)power), (ItemStack)unenchantedStack, (int)this.enchantabilityLevels[i]);
                }
                for (i = 0; i < 3; ++i) {
                    List<EnchantmentData> enchantments;
                    if (this.enchantabilityLevels[i] <= 0 || (enchantments = this.compileEnchantmentList(i)).isEmpty()) continue;
                    EnchantmentData randomEnchantmentData = enchantments.get(this.random.nextInt(enchantments.size()));
                    this.enchantments[i] = Registry.field_212628_q.func_148757_b((Object)randomEnchantmentData.field_76302_b);
                    this.enchantmentLevels[i] = randomEnchantmentData.field_76303_c;
                    Reagent reagent = Reagenchant.REAGENT_MANAGER.getReagent(this.itemStackHandler.getStackInSlot(2).func_77973_b());
                    if (!reagent.isEmpty()) {
                        for (EnchantmentData enchantmentData : enchantments) {
                            int reagentCost = reagent.getCost(enchantmentData.field_76302_b);
                            if (reagentCost <= this.reagentCost[i]) continue;
                            this.reagentCost[i] = reagentCost;
                        }
                        continue;
                    }
                    this.reagentCost[i] = 0;
                }
                this.func_75142_b();
            });
        } else {
            for (int i = 0; i < 3; ++i) {
                this.enchantments[i] = -1;
                this.enchantmentLevels[i] = -1;
                this.enchantabilityLevels[i] = 0;
                this.reagentCost[i] = 0;
            }
        }
    }

    public boolean func_75140_a(PlayerEntity player, int enchantmentTier) {
        ItemStack unenchantedStack = this.itemStackHandler.getStackInSlot(0);
        ItemStack lapisStack = this.itemStackHandler.getStackInSlot(1);
        ItemStack reagentStack = this.itemStackHandler.getStackInSlot(2);
        int lapisCost = enchantmentTier + 1;
        if ((lapisStack.func_190926_b() || lapisStack.func_190916_E() < lapisCost || reagentStack.func_190916_E() < this.reagentCost[enchantmentTier]) && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (this.enchantabilityLevels[enchantmentTier] > 0 && !unenchantedStack.func_190926_b() && (player.field_71068_ca >= lapisCost && player.field_71068_ca >= this.enchantabilityLevels[enchantmentTier] || player.field_71075_bZ.field_75098_d)) {
            this.worldPosCallable.func_221486_a((world, pos) -> {
                List<EnchantmentData> enchantments = this.compileEnchantmentList(enchantmentTier);
                Reagent reagent = Reagenchant.REAGENT_MANAGER.getReagent(reagentStack.func_77973_b());
                if (!enchantments.isEmpty()) {
                    ItemStack enchantedStack = unenchantedStack;
                    boolean isBook = unenchantedStack.func_77973_b() == Items.field_151122_aG;
                    player.func_192024_a(unenchantedStack, lapisCost);
                    if (isBook) {
                        enchantedStack = new ItemStack((IItemProvider)Items.field_151134_bR);
                        this.itemStackHandler.setStackInSlot(0, enchantedStack);
                    }
                    for (EnchantmentData enchantmentData : enchantments) {
                        if (isBook) {
                            EnchantedBookItem.func_92115_a((ItemStack)enchantedStack, (EnchantmentData)enchantmentData);
                            continue;
                        }
                        enchantedStack.func_77966_a(enchantmentData.field_76302_b, enchantmentData.field_76303_c);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        lapisStack.func_190918_g(lapisCost);
                        if (lapisStack.func_190926_b()) {
                            this.itemStackHandler.setStackInSlot(1, ItemStack.field_190927_a);
                        }
                        if (!reagent.isEmpty() && reagent.consumeReagent(unenchantedStack, enchantments)) {
                            reagentStack.func_190918_g(this.reagentCost[enchantmentTier]);
                            if (reagentStack.func_190926_b()) {
                                this.itemStackHandler.setStackInSlot(2, ItemStack.field_190927_a);
                            }
                        }
                    }
                    player.func_195066_a(Stats.field_188091_Y);
                    if (player instanceof ServerPlayerEntity) {
                        CriteriaTriggers.field_192129_i.func_192190_a((ServerPlayerEntity)player, enchantedStack, lapisCost);
                    }
                    this.xpSeed.func_221494_a(player.func_175138_ci());
                    this.onContentsChanged();
                    world.func_184133_a(null, pos, SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                }
            });
            return true;
        }
        return false;
    }

    private List<EnchantmentData> compileEnchantmentList(int enchantmentTier) {
        ItemStack unenchantedStack = this.itemStackHandler.getStackInSlot(0);
        ItemStack reagentStack = this.itemStackHandler.getStackInSlot(2);
        Reagent reagent = Reagenchant.REAGENT_MANAGER.getReagent(reagentStack.func_77973_b());
        int enchantabilityLevel = this.enchantabilityLevels[enchantmentTier];
        this.random.setSeed(this.xpSeed.func_221495_b() + enchantmentTier);
        List reagentEnchantments = new ArrayList();
        List defaultEnchantments = EnchantmentHelper.func_77513_b((Random)this.random, (ItemStack)unenchantedStack, (int)enchantabilityLevel, (boolean)false);
        if (!reagent.isEmpty() && reagent.canApplyEnchantments(unenchantedStack)) {
            int finalEnchantabilityLevel = enchantabilityLevel;
            reagentEnchantments = (List)this.worldPosCallable.func_221485_a((world, pos) -> reagent.compileEnchantmentList(unenchantedStack, enchantmentTier, finalEnchantabilityLevel, this.random), reagentEnchantments);
        }
        ArrayList<EnchantmentData> refinedEnchantments = new ArrayList<EnchantmentData>();
        if (!reagentEnchantments.isEmpty()) {
            EnchantmentData removedEnchantment = (EnchantmentData)WeightedRandom.func_76271_a((Random)this.random, reagentEnchantments);
            refinedEnchantments.add((EnchantmentData)reagentEnchantments.remove(reagentEnchantments.indexOf(removedEnchantment)));
            while (this.random.nextInt(50) <= enchantabilityLevel) {
                EnchantmentHelper.func_185282_a((List)defaultEnchantments, (EnchantmentData)((EnchantmentData)Util.func_223378_a(refinedEnchantments)));
                if (!defaultEnchantments.isEmpty()) {
                    if (!reagentEnchantments.isEmpty()) {
                        removedEnchantment = (EnchantmentData)WeightedRandom.func_76271_a((Random)this.random, reagentEnchantments);
                        refinedEnchantments.add((EnchantmentData)reagentEnchantments.remove(reagentEnchantments.indexOf(removedEnchantment)));
                    } else {
                        refinedEnchantments.add((EnchantmentData)WeightedRandom.func_76271_a((Random)this.random, (List)defaultEnchantments));
                    }
                    enchantabilityLevel /= 2;
                    continue;
                }
                break;
            }
        } else {
            refinedEnchantments.addAll(defaultEnchantments);
        }
        if (unenchantedStack.func_77973_b() == Items.field_151122_aG && refinedEnchantments.size() > 1) {
            if (!reagentEnchantments.isEmpty()) {
                refinedEnchantments.remove(RandomHelper.getNumberInRange((int)1, (int)(refinedEnchantments.size() - 1), (Random)this.random));
            } else {
                refinedEnchantments.remove(this.random.nextInt(refinedEnchantments.size()));
            }
        }
        return refinedEnchantments;
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.worldPosCallable.func_221486_a((world, pos) -> {
            if (this.itemStackHandler.getStackInSlot(0).func_77948_v()) {
                if (!player.func_70089_S() || player instanceof ServerPlayerEntity && ((ServerPlayerEntity)player).func_193105_t()) {
                    player.func_71019_a(this.itemStackHandler.extractItem(0, 64, false), false);
                } else {
                    player.field_71071_by.func_191975_a(world, this.itemStackHandler.extractItem(0, 64, false));
                }
            }
        });
    }

    public boolean func_75145_c(PlayerEntity player) {
        return ReagentTableContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)player, (Block)Blocks.field_150381_bn);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(slotStack, 3, 38, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index == 1) {
                if (!this.func_75135_a(slotStack, 3, 38, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index == 2) {
                if (!this.func_75135_a(slotStack, 3, 38, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (slotStack.func_77973_b() == Items.field_196128_bn) {
                if (!this.func_75135_a(slotStack, 1, 2, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (Reagenchant.REAGENT_MANAGER.isReagent(slotStack.func_77973_b())) {
                if (!this.func_75135_a(slotStack, 2, 3, true)) {
                    if (((Slot)this.field_75151_b.get(0)).func_75216_d() || !((Slot)this.field_75151_b.get(0)).func_75214_a(slotStack)) {
                        return ItemStack.field_190927_a;
                    }
                    if (!slotStack.func_190926_b()) {
                        ((Slot)this.field_75151_b.get(0)).func_75215_d(slotStack.func_77979_a(1));
                    }
                    return ItemStack.field_190927_a;
                }
            } else {
                if (((Slot)this.field_75151_b.get(0)).func_75216_d() || !((Slot)this.field_75151_b.get(0)).func_75214_a(slotStack)) {
                    return ItemStack.field_190927_a;
                }
                if (!slotStack.func_190926_b()) {
                    ((Slot)this.field_75151_b.get(0)).func_75215_d(slotStack.func_77979_a(1));
                }
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slotStack);
        }
        return stack;
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public Random getRandom() {
        return this.random;
    }

    public int getXpSeed() {
        return this.xpSeed.func_221495_b();
    }

    public int[] getEnchantments() {
        return this.enchantments;
    }

    public int[] getEnchantmentLevels() {
        return this.enchantmentLevels;
    }

    public int[] getEnchantabilityLevels() {
        return this.enchantabilityLevels;
    }

    public int[] getReagentCost() {
        return this.reagentCost;
    }

    public int getLapisAmount() {
        ItemStack lapisStack = this.itemStackHandler.getStackInSlot(1);
        return lapisStack.func_190916_E();
    }

    public int getReagentAmount() {
        ItemStack reagentStack = this.itemStackHandler.getStackInSlot(2);
        return reagentStack.func_190916_E();
    }

    private float getEnchantPower(World world, BlockPos pos) {
        return world.func_180495_p(pos).getEnchantPowerBonus((IWorldReader)world, pos);
    }
}

