/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant.network.item.reagent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import logictechcorp.reagenchant.Reagenchant;
import logictechcorp.reagenchant.reagent.Reagent;
import logictechcorp.reagenchant.reagent.ReagentEnchantData;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MessageSUpdateReagentsPacket {
    private final Collection<Reagent> reagents;

    public MessageSUpdateReagentsPacket(Collection<Reagent> reagents) {
        this.reagents = reagents;
    }

    public static MessageSUpdateReagentsPacket deserialize(PacketBuffer buffer) {
        ArrayList<Reagent> reagents = new ArrayList<Reagent>();
        int reagentAmount = buffer.readInt();
        for (int reagentIndex = 0; reagentIndex < reagentAmount; ++reagentIndex) {
            ResourceLocation itemRegistryName = buffer.func_192575_l();
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemRegistryName);
            Reagent reagent = new Reagent(item);
            int enchantmentAmount = buffer.readInt();
            for (int enchantmentIndex = 0; enchantmentIndex < enchantmentAmount; ++enchantmentIndex) {
                ResourceLocation enchantmentRegistryName = buffer.func_192575_l();
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantmentRegistryName);
                int minimumEnchantmentLevel = buffer.readInt();
                int maximumEnchantmentLevel = buffer.readInt();
                float enchantmentProbability = buffer.readFloat();
                int reagentCost = buffer.readInt();
                ReagentEnchantData reagentEnchantData = new ReagentEnchantData(enchantment, minimumEnchantmentLevel, maximumEnchantmentLevel, enchantmentProbability, reagentCost);
                reagent.addEnchantment(reagentEnchantData);
            }
            reagents.add(reagent);
        }
        return new MessageSUpdateReagentsPacket(reagents);
    }

    public void serialize(PacketBuffer buffer) {
        buffer.writeInt(this.reagents.size());
        for (Reagent reagent : this.reagents) {
            buffer.func_192572_a(reagent.getItem().getRegistryName());
            Set<Enchantment> enchantments = reagent.getEnchantments();
            buffer.writeInt(enchantments.size());
            for (Enchantment enchantment : enchantments) {
                ReagentEnchantData reagentEnchantData = reagent.getReagentEnchantData(enchantment);
                buffer.func_192572_a(enchantment.getRegistryName());
                buffer.writeInt(reagentEnchantData.getMinimumEnchantmentLevel());
                buffer.writeInt(reagentEnchantData.getMaximumEnchantmentLevel());
                buffer.writeFloat(reagentEnchantData.getEnchantmentProbability());
                buffer.writeInt(reagentEnchantData.getReagentCost());
            }
        }
    }

    public static void handle(MessageSUpdateReagentsPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            Reagenchant.REAGENT_MANAGER.syncClientReagents(packet.reagents);
            context.setPacketHandled(true);
        }
    }
}

