/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant.reagent;

import com.mojang.datafixers.Dynamic;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ReagentEnchantData {
    public static final ReagentEnchantData EMPTY = new ReagentEnchantData(null, 0, 0, 0.0f, 0);
    private final Enchantment enchantment;
    private final int minimumEnchantmentLevel;
    private final int maximumEnchantmentLevel;
    private final float enchantmentProbability;
    private final int reagentCost;

    public ReagentEnchantData(Enchantment enchantment, int minimumEnchantmentLevel, int maximumEnchantmentLevel, float enchantmentProbability, int reagentCost) {
        this.enchantment = enchantment;
        this.minimumEnchantmentLevel = minimumEnchantmentLevel;
        this.maximumEnchantmentLevel = maximumEnchantmentLevel;
        this.enchantmentProbability = enchantmentProbability;
        this.reagentCost = reagentCost;
    }

    public static <T> ReagentEnchantData deserialize(Dynamic<T> dynamic) {
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(dynamic.get("enchantment").asString("null")));
        if (enchantment != null) {
            float probability = dynamic.get("probability").asFloat(0.5f);
            if (probability < 0.0f) {
                probability = 0.5f;
            }
            if (probability > 0.0f) {
                int reagentCost;
                int minimumEnchantmentLevel = dynamic.get("minimumEnchantmentLevel").asInt(enchantment.func_77319_d());
                int maximumEnchantmentLevel = dynamic.get("maximumEnchantmentLevel").asInt(enchantment.func_77325_b());
                if (minimumEnchantmentLevel < 1) {
                    minimumEnchantmentLevel = 1;
                }
                if (maximumEnchantmentLevel > 100) {
                    maximumEnchantmentLevel = 100;
                }
                if ((reagentCost = dynamic.get("reagentCost").asInt(1)) < 0) {
                    reagentCost = 1;
                }
                return new ReagentEnchantData(enchantment, minimumEnchantmentLevel, maximumEnchantmentLevel, probability, reagentCost);
            }
        }
        return EMPTY;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public int getMinimumEnchantmentLevel() {
        return this.minimumEnchantmentLevel;
    }

    public int getMaximumEnchantmentLevel() {
        return this.maximumEnchantmentLevel;
    }

    public float getEnchantmentProbability() {
        return this.enchantmentProbability;
    }

    public int getReagentCost() {
        return this.reagentCost;
    }
}

