/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.block;

import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EternalFireBlock
extends Block {
    public static final IntegerProperty AGE = BlockStateProperties.field_208171_X;
    public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    public static final BooleanProperty UP = SixWayBlock.field_196496_z;
    private static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)SixWayBlock.field_196491_B.entrySet().stream().filter(direction -> direction.getKey() != Direction.DOWN).collect(Util.func_199749_a());

    public EternalFireBlock(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return this.func_196260_a(state, (IWorldReader)world, currentPos) ? (BlockState)this.getStateForPlacement((IBlockReader)world, currentPos).func_206870_a((IProperty)AGE, state.func_177229_b((IProperty)AGE)) : Blocks.field_150350_a.func_176223_P();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getStateForPlacement((IBlockReader)context.func_195991_k(), context.func_195995_a());
    }

    public BlockState getStateForPlacement(IBlockReader world, BlockPos pos) {
        BlockPos downPos = pos.func_177977_b();
        BlockState downState = world.func_180495_p(downPos);
        if (!this.canCatchFire(world, pos, Direction.UP) && !Block.func_220056_d((BlockState)downState, (IBlockReader)world, (BlockPos)downPos, (Direction)Direction.UP)) {
            BlockState state = this.func_176223_P();
            for (Direction direction : Direction.values()) {
                BooleanProperty property = FACING_TO_PROPERTY_MAP.get(direction);
                if (property == null) continue;
                state = (BlockState)state.func_206870_a((IProperty)property, (Comparable)Boolean.valueOf(this.canCatchFire(world, pos.func_177972_a(direction), direction.func_176734_d())));
            }
            return state;
        }
        return this.func_176223_P();
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos downPos = pos.func_177977_b();
        return world.func_180495_p(downPos).func_224755_d((IBlockReader)world, downPos, Direction.UP) || this.areNeighborsFlammable((IBlockReader)world, pos);
    }

    public int func_149738_a(IWorldReader world) {
        return 30;
    }

    public void func_196267_b(BlockState state, World world, BlockPos pos, Random random) {
        if (world.func_82736_K().func_223586_b(GameRules.field_223598_a)) {
            if (!world.isAreaLoaded(pos, 2)) {
                return;
            }
            if (!state.func_196955_c((IWorldReader)world, pos)) {
                world.func_217377_a(pos, false);
            }
            BlockPos downPos = pos.func_177977_b();
            boolean isFireSource = world.func_180495_p(downPos).isFireSource((IBlockReader)world, downPos, Direction.UP);
            int age = (Integer)state.func_177229_b((IProperty)AGE);
            if (!isFireSource && world.func_72896_J() && this.isBeingRainedOn(world, pos) && age > 0 && random.nextFloat() < 0.2f + (float)age * 0.03f) {
                world.func_217377_a(pos, false);
            } else {
                if (age > 0 && age < 15) {
                    state = (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(age + random.nextInt(3) / 2));
                    world.func_180501_a(pos, state, 4);
                }
                if (!isFireSource) {
                    world.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)world) + random.nextInt(10));
                    if (!this.areNeighborsFlammable((IBlockReader)world, pos)) {
                        if (!world.func_180495_p(downPos).func_224755_d((IBlockReader)world, downPos, Direction.UP) || age > 3) {
                            world.func_217377_a(pos, false);
                        }
                        return;
                    }
                    if (age == 15 && random.nextInt(4) == 0 && !this.canCatchFire((IBlockReader)world, pos.func_177977_b(), Direction.UP)) {
                        world.func_217377_a(pos, false);
                        return;
                    }
                }
                boolean isHighHumidity = world.func_180502_D(pos);
                int humidityChance = world.func_180502_D(pos) ? -50 : 0;
                this.tryCatchFire(world, pos, 300 + humidityChance, random, age, Direction.WEST);
                this.tryCatchFire(world, pos, 300 + humidityChance, random, age, Direction.EAST);
                this.tryCatchFire(world, pos, 250 + humidityChance, random, age, Direction.UP);
                this.tryCatchFire(world, pos, 250 + humidityChance, random, age, Direction.DOWN);
                this.tryCatchFire(world, pos, 300 + humidityChance, random, age, Direction.SOUTH);
                this.tryCatchFire(world, pos, 300 + humidityChance, random, age, Direction.NORTH);
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                    for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                        for (int yOffset = -1; yOffset <= 4; ++yOffset) {
                            if (xOffset == 0 && yOffset == 0 && zOffset == 0) continue;
                            int encouragement = 100;
                            if (yOffset > 1) {
                                encouragement += (yOffset - 1) * 100;
                            }
                            mutablePos.func_189533_g((Vec3i)pos).func_196234_d(xOffset, yOffset, zOffset);
                            int neighborEncouragement = this.getNeighborEncouragement((IWorldReader)world, (BlockPos)mutablePos);
                            if (neighborEncouragement <= 0) continue;
                            int adjustedEncouragement = (neighborEncouragement + 40 + world.func_175659_aa().func_151525_a() * 7) / (age + 30);
                            if (isHighHumidity) {
                                adjustedEncouragement /= 2;
                            }
                            if (adjustedEncouragement <= 0 || random.nextInt(encouragement) > adjustedEncouragement || world.func_72896_J() || this.isBeingRainedOn(world, (BlockPos)mutablePos)) continue;
                            int neighborAge = Math.min(15, age + 1);
                            world.func_180501_a((BlockPos)mutablePos, (BlockState)this.getStateForPlacement((IBlockReader)world, (BlockPos)mutablePos).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(neighborAge)), 3);
                        }
                    }
                }
            }
        }
    }

    protected boolean isBeingRainedOn(World world, BlockPos pos) {
        return world.func_175727_C(pos) || world.func_175727_C(pos.func_177976_e()) || world.func_175727_C(pos.func_177974_f()) || world.func_175727_C(pos.func_177978_c()) || world.func_175727_C(pos.func_177968_d());
    }

    protected void tryCatchFire(World world, BlockPos pos, int chance, Random random, int age, Direction direction) {
        BlockPos targetPos = pos.func_177972_a(direction.func_176734_d());
        int flammability = world.func_180495_p(targetPos).getFlammability((IBlockReader)world, targetPos, direction);
        if (random.nextInt(chance) < flammability) {
            BlockState state = world.func_180495_p(targetPos);
            if (random.nextInt(age + 10) < 5) {
                int newAge = Math.min(age + 1, 15);
                world.func_180501_a(targetPos, (BlockState)this.getStateForPlacement((IBlockReader)world, targetPos).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(newAge)), 3);
            } else if (age > 0) {
                world.func_217377_a(pos, false);
            }
            state.catchFire(world, targetPos, direction, null);
        }
    }

    private boolean areNeighborsFlammable(IBlockReader world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(world, pos.func_177972_a(direction), direction.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(IWorldReader world, BlockPos pos) {
        if (!world.func_175623_d(pos)) {
            return 0;
        }
        int flammability = 0;
        for (Direction direction : Direction.values()) {
            flammability = Math.max(world.func_180495_p(pos.func_177972_a(direction)).getFlammability((IBlockReader)world, pos.func_177972_a(direction), direction.func_176734_d()), flammability);
        }
        return flammability;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c() && (world.field_73011_w.func_186058_p() != DimensionType.field_223227_a_ && world.field_73011_w.func_186058_p() != DimensionType.field_223228_b_ || !((NetherPortalBlock)Blocks.field_150427_aO).func_176548_d((IWorld)world, pos))) {
            if (!state.func_196955_c((IWorldReader)world, pos)) {
                world.func_217377_a(pos, false);
            } else {
                world.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)world) + world.field_73012_v.nextInt(10));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        block12: {
            block11: {
                double posZ;
                double posY;
                double posX;
                int particle;
                BlockPos downPos;
                if (rand.nextInt(24) == 0) {
                    world.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
                }
                if (this.canCatchFire((IBlockReader)world, downPos = pos.func_177977_b(), Direction.UP) || Block.func_220056_d((BlockState)world.func_180495_p(downPos), (IBlockReader)world, (BlockPos)downPos, (Direction)Direction.UP)) break block11;
                if (this.canCatchFire((IBlockReader)world, downPos.func_177976_e(), Direction.EAST)) {
                    for (particle = 0; particle < 2; ++particle) {
                        posX = (double)pos.func_177958_n() + rand.nextDouble() * (double)0.1f;
                        posY = (double)pos.func_177956_o() + rand.nextDouble();
                        posZ = (double)pos.func_177952_p() + rand.nextDouble();
                        world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, posX, posY, posZ, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canCatchFire((IBlockReader)world, pos.func_177974_f(), Direction.WEST)) {
                    for (particle = 0; particle < 2; ++particle) {
                        posX = (double)(pos.func_177958_n() + 1) - rand.nextDouble() * (double)0.1f;
                        posY = (double)pos.func_177956_o() + rand.nextDouble();
                        posZ = (double)pos.func_177952_p() + rand.nextDouble();
                        world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, posX, posY, posZ, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canCatchFire((IBlockReader)world, pos.func_177978_c(), Direction.SOUTH)) {
                    for (particle = 0; particle < 2; ++particle) {
                        posX = (double)pos.func_177958_n() + rand.nextDouble();
                        posY = (double)pos.func_177956_o() + rand.nextDouble();
                        posZ = (double)pos.func_177952_p() + rand.nextDouble() * (double)0.1f;
                        world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, posX, posY, posZ, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canCatchFire((IBlockReader)world, pos.func_177968_d(), Direction.NORTH)) {
                    for (particle = 0; particle < 2; ++particle) {
                        posX = (double)pos.func_177958_n() + rand.nextDouble();
                        posY = (double)pos.func_177956_o() + rand.nextDouble();
                        posZ = (double)(pos.func_177952_p() + 1) - rand.nextDouble() * (double)0.1f;
                        world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, posX, posY, posZ, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.canCatchFire((IBlockReader)world, pos.func_177984_a(), Direction.DOWN)) break block12;
                for (particle = 0; particle < 2; ++particle) {
                    posX = (double)pos.func_177958_n() + rand.nextDouble();
                    posY = (double)(pos.func_177956_o() + 1) - rand.nextDouble() * (double)0.1f;
                    posZ = (double)pos.func_177952_p() + rand.nextDouble();
                    world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, posX, posY, posZ, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            for (int particle = 0; particle < 3; ++particle) {
                double posX = (double)pos.func_177958_n() + rand.nextDouble();
                double posY = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
                double posZ = (double)pos.func_177952_p() + rand.nextDouble();
                world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, posX, posY, posZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE, NORTH, EAST, SOUTH, WEST, UP});
    }

    public boolean canCatchFire(IBlockReader world, BlockPos pos, Direction face) {
        return world.func_180495_p(pos).isFlammable(world, pos, face);
    }
}

