/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.block;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ModPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = EnumProperty.func_177709_a((String)"axis", Direction.Axis.class);
    protected static final VoxelShape X_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Y_SHAPE = Block.func_208617_a((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    protected static final VoxelShape Z_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public ModPortalBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.Y));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if (random.nextInt(100) == 0) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double posX = (float)pos.func_177958_n() + random.nextFloat();
            double posY = (float)pos.func_177956_o() + random.nextFloat();
            double posZ = (float)pos.func_177952_p() + random.nextFloat();
            double speedX = ((double)random.nextFloat() - 0.5) * 0.5;
            double speedY = ((double)random.nextFloat() - 0.5) * 0.5;
            double speedZ = ((double)random.nextFloat() - 0.5) * 0.5;
            int multiplier = random.nextInt(2) * 2 - 1;
            if (world.func_180495_p(pos.func_177976_e()).func_177230_c() != this && world.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                posX = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)multiplier;
                speedX = random.nextFloat() * 2.0f * (float)multiplier;
            } else {
                posZ = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)multiplier;
                speedZ = random.nextFloat() * 2.0f * (float)multiplier;
            }
            world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, posX, posY, posZ, speedX, speedY, speedZ);
        }
    }

    public void func_196267_b(BlockState state, World world, BlockPos pos, Random random) {
        Direction.Axis axis = (Direction.Axis)state.func_177229_b(AXIS);
        if (axis == Direction.Axis.X) {
            if (world.func_175623_d(pos.func_177977_b()) || world.func_175623_d(pos.func_177984_a()) || world.func_175623_d(pos.func_177978_c()) || world.func_175623_d(pos.func_177968_d())) {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        } else if (axis == Direction.Axis.Y) {
            if (world.func_175623_d(pos.func_177978_c()) || world.func_175623_d(pos.func_177968_d()) || world.func_175623_d(pos.func_177976_e()) || world.func_175623_d(pos.func_177974_f())) {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        } else if (axis == Direction.Axis.Z && (world.func_175623_d(pos.func_177977_b()) || world.func_175623_d(pos.func_177984_a()) || world.func_175623_d(pos.func_177976_e()) || world.func_175623_d(pos.func_177974_f()))) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState newState, boolean bool) {
        world.func_205220_G_().func_205360_a(pos, (Object)this, 2);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos fromPos) {
        Direction.Axis axis = (Direction.Axis)state.func_177229_b(AXIS);
        if (axis == Direction.Axis.X ? (pos.func_177976_e().equals((Object)fromPos) || pos.func_177974_f().equals((Object)fromPos)) && world.func_180495_p(fromPos).func_177230_c() == this : (axis == Direction.Axis.Y ? (pos.func_177977_b().equals((Object)fromPos) || pos.func_177984_a().equals((Object)fromPos)) && world.func_180495_p(fromPos).func_177230_c() == this : axis == Direction.Axis.Z && (pos.func_177978_c().equals((Object)fromPos) || pos.func_177968_d().equals((Object)fromPos)) && world.func_180495_p(fromPos).func_177230_c() == this)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, facing, facingState, world, pos, fromPos);
    }

    public abstract void func_196262_a(BlockState var1, World var2, BlockPos var3, Entity var4);

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Y: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Y);
                    }
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AXIS});
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b(AXIS)) {
            case X: {
                return X_SHAPE;
            }
            default: {
                return Y_SHAPE;
            }
            case Z: 
        }
        return Z_SHAPE;
    }

    public static int getMetaForAxis(Direction.Axis axis) {
        return axis == Direction.Axis.X ? 0 : (axis == Direction.Axis.Y ? 1 : 2);
    }

    public abstract boolean isPortalIgniter(World var1, BlockPos var2);

    public abstract boolean isPortalPart(World var1, BlockPos var2);

    private void addNeighborBlocks(BlockPos pos, Direction.Axis axis, Queue<BlockPos> neighbors) {
        for (Direction direction : Direction.values()) {
            if (axis == Direction.Axis.X && (direction == Direction.EAST || direction == Direction.WEST) || axis == Direction.Axis.Y && (direction == Direction.DOWN || direction == Direction.UP) || axis == Direction.Axis.Z && (direction == Direction.NORTH || direction == Direction.SOUTH)) continue;
            neighbors.add(pos.func_177972_a(direction));
        }
    }

    public boolean trySpawnPortal(World world, BlockPos pos) {
        for (Direction.Axis axis : Direction.Axis.values()) {
            for (Direction direction : Direction.values()) {
                Queue<BlockPos> portalBlocks = this.getPortalBlocks(world, pos.func_177972_a(direction), axis);
                if (portalBlocks.size() <= 0) continue;
                for (BlockPos newPos : portalBlocks) {
                    world.func_175656_a(newPos, (BlockState)this.func_176223_P().func_206870_a(AXIS, (Comparable)axis));
                }
                return true;
            }
        }
        return false;
    }

    private Queue<BlockPos> getPortalBlocks(World world, BlockPos pos, Direction.Axis axis) {
        ArrayDeque<BlockPos> portalBlocks = new ArrayDeque<BlockPos>();
        ArrayDeque<BlockPos> toProcess = new ArrayDeque<BlockPos>();
        int chances = 0;
        toProcess.add(pos);
        while (!toProcess.isEmpty()) {
            BlockPos newPos = (BlockPos)toProcess.remove();
            if (portalBlocks.contains(newPos)) continue;
            if (world.func_175623_d(newPos) || this.isPortalIgniter(world, newPos)) {
                int neighborBlocks = this.getNeighborBlocks(world, newPos, portalBlocks, axis);
                if (neighborBlocks < 2) {
                    if (chances < 40) {
                        ++chances;
                        neighborBlocks += 2;
                    } else {
                        return new ArrayDeque<BlockPos>();
                    }
                }
                if (neighborBlocks >= 2) {
                    portalBlocks.add(newPos);
                    this.addNeighborBlocks(newPos, axis, toProcess);
                    continue;
                }
                if (this.isPortalPart(world, newPos)) continue;
                return new ArrayDeque<BlockPos>();
            }
            if (this.isPortalPart(world, newPos)) continue;
            return new ArrayDeque<BlockPos>();
        }
        return portalBlocks;
    }

    private int getNeighborBlocks(World world, BlockPos pos, Queue<BlockPos> portalBlocks, Direction.Axis axis) {
        int sides = 0;
        ArrayDeque<BlockPos> neighbors = new ArrayDeque<BlockPos>();
        this.addNeighborBlocks(pos, axis, neighbors);
        for (BlockPos newPos : neighbors) {
            if (!portalBlocks.contains(newPos) && !this.isPortalPart(world, newPos)) continue;
            ++sides;
        }
        return sides;
    }
}

