/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.PlantType;

public class TriplePlantBlock
extends BushBlock {
    public static final EnumProperty<Part> PART = EnumProperty.func_177709_a((String)"part", Part.class);

    public TriplePlantBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(PART, (Comparable)((Object)Part.TOP)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{PART});
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState directionState, IWorld world, BlockPos pos, BlockPos directionPos) {
        if (direction == Direction.UP) {
            if (directionState.func_177230_c() == this) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a(PART, (Comparable)((Object)Part.fromMeta(((Part)((Object)directionState.func_177229_b(PART))).ordinal() + 1))), 3);
            } else if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150425_aM) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a(PART, (Comparable)((Object)Part.TOP)), 3);
            } else {
                world.func_180501_a(pos, (BlockState)state.func_206870_a(PART, (Comparable)((Object)Part.fromMeta(((Part)((Object)state.func_177229_b(PART))).ordinal() - 1))), 3);
            }
        }
        return super.func_196271_a(state, direction, directionState, world, pos, directionPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (state.func_177230_c() == this && state.func_177229_b(PART) != Part.TOP) {
            BlockPos groundPos = pos.func_177977_b();
            return this.func_200014_a_(world.func_180495_p(groundPos), (IBlockReader)world, groundPos);
        }
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != this) {
            return super.func_196260_a(state, world, pos);
        }
        return world.func_180495_p(pos.func_177979_c(3)).func_177230_c() != this;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader world, BlockPos pos) {
        Block block = state.func_177230_c();
        return block == this || block == Blocks.field_150425_aM;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        return pos.func_177956_o() < context.func_195991_k().func_201675_m().getHeight() - 2 && context.func_195991_k().func_180495_p(pos.func_177984_a()).func_196953_a(context) && context.func_195991_k().func_180495_p(pos.func_177981_b(2)).func_196953_a(context) ? super.func_196258_a(context) : null;
    }

    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.XZ;
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.Nether;
    }

    public void placeAt(IWorld world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != this) {
            int height = random.nextInt(3) + 1;
            if (height == 1) {
                world.func_180501_a(pos, (BlockState)this.func_176223_P().func_206870_a(PART, (Comparable)((Object)Part.TOP)), 3);
            } else if (height == 2) {
                world.func_180501_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a(PART, (Comparable)((Object)Part.TOP)), 3);
                world.func_180501_a(pos, (BlockState)this.func_176223_P().func_206870_a(PART, (Comparable)((Object)Part.MIDDLE)), 3);
            } else {
                world.func_180501_a(pos.func_177981_b(2), (BlockState)this.func_176223_P().func_206870_a(PART, (Comparable)((Object)Part.TOP)), 3);
                world.func_180501_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a(PART, (Comparable)((Object)Part.MIDDLE)), 3);
                world.func_180501_a(pos, (BlockState)this.func_176223_P().func_206870_a(PART, (Comparable)((Object)Part.BOTTOM)), 3);
            }
        }
    }

    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.DANGER_CACTUS;
    }

    public static enum Part implements IStringSerializable
    {
        TOP,
        MIDDLE,
        BOTTOM;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }

        public static Part fromMeta(int meta) {
            if (meta < 0 || meta >= Part.values().length) {
                meta = 0;
            }
            return Part.values()[meta];
        }
    }
}

