/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.biome;

import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;

public class BiomeData {
    public static final BiomeData EMPTY = new BiomeData(Biomes.field_76772_c, 10, true, true, true, true, false);
    protected final Biome biome;
    protected int generationWeight;
    protected boolean useDefaultEntities;
    protected boolean useDefaultCarvers;
    protected boolean useDefaultFeatures;
    protected boolean useDefaultStructures;
    protected boolean isSubBiome;
    protected final Map<BlockType, BlockState> blocks;
    protected final Map<EntityClassification, List<Biome.SpawnListEntry>> spawns;
    protected final Map<GenerationStage.Carving, List<ConfiguredCarver<?>>> carvers;
    protected final Map<GenerationStage.Decoration, List<ConfiguredFeature<?>>> features;
    protected final Map<Structure<?>, IFeatureConfig> structures;
    protected final List<BiomeData> subBiomes;

    public BiomeData(Biome biome, int generationWeight, boolean useDefaultEntities, boolean useDefaultCarvers, boolean useDefaultFeatures, boolean useDefaultStructures, boolean isSubBiome) {
        this.biome = biome;
        this.generationWeight = generationWeight;
        this.useDefaultEntities = useDefaultEntities;
        this.useDefaultCarvers = useDefaultCarvers;
        this.useDefaultFeatures = useDefaultFeatures;
        this.useDefaultStructures = useDefaultStructures;
        this.isSubBiome = isSubBiome;
        this.blocks = new EnumMap<BlockType, BlockState>(BlockType.class);
        this.spawns = new EnumMap<EntityClassification, List<Biome.SpawnListEntry>>(EntityClassification.class);
        this.carvers = new EnumMap(GenerationStage.Carving.class);
        this.features = new EnumMap(GenerationStage.Decoration.class);
        this.structures = new HashMap();
        this.subBiomes = new ArrayList<BiomeData>();
    }

    public void configureBiome() {
    }

    public void resetBiome() {
    }

    public void addBiomeBlock(BlockType blockType, BlockState blockState) {
        this.blocks.put(blockType, blockState);
    }

    public void addEntitySpawn(Biome.SpawnListEntry spawnListEntry) {
        if (spawnListEntry.field_76292_a > 0) {
            this.spawns.computeIfAbsent(spawnListEntry.field_200702_b.func_220339_d(), k -> new ArrayList()).add(spawnListEntry);
        }
        for (EntityClassification classification : EntityClassification.values()) {
            this.biome.func_76747_a(classification).removeIf(entry -> entry.field_200702_b == spawnListEntry.field_200702_b);
        }
    }

    public void addCarver(GenerationStage.Carving stage, ConfiguredCarver<?> carver) {
        this.carvers.computeIfAbsent(stage, k -> new ArrayList()).add(carver);
    }

    public void addFeature(GenerationStage.Decoration stage, ConfiguredFeature<?> feature) {
        this.features.computeIfAbsent(stage, k -> new ArrayList()).add(feature);
    }

    public <C extends IFeatureConfig> void addStructure(Structure<?> structure, C config) {
        this.structures.put(structure, config);
    }

    public void addSubBiome(BiomeData subBiomeData) {
        this.subBiomes.add(subBiomeData);
    }

    public void carve(GenerationStage.Carving stage, IChunk chunk, long seed, int seaLevel) {
        ChunkPos chunkPos = chunk.func_76632_l();
        int chunkX = chunkPos.field_77276_a;
        int chunkZ = chunkPos.field_77275_b;
        SharedSeedRandom random = new SharedSeedRandom();
        for (int posX = chunkX - 8; posX <= chunkX + 8; ++posX) {
            for (int posZ = chunkZ - 8; posZ <= chunkZ + 8; ++posZ) {
                ArrayList carvers = new ArrayList();
                if (this.useDefaultCarvers) {
                    carvers.addAll(this.biome.func_203603_a(stage));
                }
                carvers.addAll(this.getCarvers(stage));
                ListIterator carverIter = carvers.listIterator();
                while (carverIter.hasNext()) {
                    int index = carverIter.nextIndex();
                    ConfiguredCarver carver = (ConfiguredCarver)carverIter.next();
                    random.func_202425_c(seed + (long)index, posX, posZ);
                    if (!carver.func_222730_a((Random)random, posX, posZ)) continue;
                    carver.func_222731_a(chunk, (Random)random, seaLevel, posX, posZ, chunkX, chunkZ, chunk.func_205749_a(stage));
                }
            }
        }
    }

    public void decorate(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom random, BlockPos pos) {
        int featureCount = 0;
        ArrayList features = new ArrayList();
        if (this.useDefaultFeatures) {
            features.addAll(this.biome.func_203607_a(stage));
        }
        features.addAll(this.getFeatures(stage));
        for (ConfiguredFeature configuredFeature : features) {
            random.func_202426_b(seed, featureCount, stage.ordinal());
            try {
                configuredFeature.func_222734_a(world, chunkGenerator, (Random)random, pos);
            }
            catch (Exception exception) {
                CrashReport crashReport = CrashReport.func_85055_a((Throwable)exception, (String)"Feature placement");
                crashReport.func_85058_a("Feature").func_71507_a("Id", (Object)configuredFeature.field_222737_a.getRegistryName()).func_189529_a("Description", configuredFeature.field_222737_a::toString);
                throw new ReportedException(crashReport);
            }
            ++featureCount;
        }
    }

    public <C extends IFeatureConfig> boolean hasStructure(Structure<C> structure) {
        return this.structures.containsKey(structure) ? true : (this.useDefaultStructures ? this.biome.func_201858_a(structure) : false);
    }

    public Biome getBiome() {
        return this.biome;
    }

    public int getGenerationWeight() {
        return this.generationWeight;
    }

    public boolean useDefaultEntities() {
        return this.useDefaultEntities;
    }

    public boolean useDefaultCarvers() {
        return this.useDefaultCarvers;
    }

    public boolean useDefaultFeatures() {
        return this.useDefaultFeatures;
    }

    public boolean useDefaultStructures() {
        return this.useDefaultStructures;
    }

    public boolean isSubBiome() {
        return this.isSubBiome;
    }

    public BlockState getBiomeBlock(BlockType blockType) {
        BlockState state = this.blocks.get((Object)blockType);
        if (state == null) {
            ISurfaceBuilderConfig surfaceBuilderConfig = this.biome.func_203944_q();
            switch (blockType) {
                case SURFACE_BLOCK: {
                    state = surfaceBuilderConfig.func_204108_a();
                    break;
                }
                case SUBSURFACE_BLOCK: {
                    state = surfaceBuilderConfig.func_204109_b();
                    break;
                }
                case LIQUID_BLOCK: {
                    state = Blocks.field_150353_l.func_176223_P();
                }
            }
            this.addBiomeBlock(blockType, state);
        }
        return state;
    }

    public List<Biome.SpawnListEntry> getSpawns(EntityClassification classification) {
        return this.spawns.computeIfAbsent(classification, k -> new ArrayList());
    }

    public List<ConfiguredCarver<?>> getCarvers(GenerationStage.Carving stage) {
        return this.carvers.computeIfAbsent(stage, k -> new ArrayList());
    }

    public List<ConfiguredFeature<?>> getFeatures(GenerationStage.Decoration stage) {
        return this.features.computeIfAbsent(stage, k -> new ArrayList());
    }

    public <C extends IFeatureConfig> C getStructureConfig(Structure<C> structure) {
        IFeatureConfig config = this.structures.get(structure);
        return (C)(config != null ? config : (this.useDefaultStructures ? this.biome.func_201857_b(structure) : null));
    }

    public List<BiomeData> getSubBiomes() {
        return this.subBiomes;
    }

    public static enum BlockType {
        SURFACE_BLOCK("surface"),
        SUBSURFACE_BLOCK("subsurface"),
        LIQUID_BLOCK("liquid");

        private String identifier;

        private BlockType(String identifier) {
            this.identifier = identifier;
        }

        public static <T> BlockType deserialize(Dynamic<T> dynamic) {
            for (BlockType type : BlockType.values()) {
                if (!dynamic.asString().orElse("").equals(type.toString())) continue;
                return type;
            }
            return SURFACE_BLOCK;
        }

        public String toString() {
            return this.identifier;
        }
    }
}

