/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.biome;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import logictechcorp.libraryex.LibraryEx;
import logictechcorp.libraryex.world.biome.BiomeData;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.EntityType;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;

public class BiomeDataManager
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<ResourceLocation, BiomeData> biomeData = new HashMap<ResourceLocation, BiomeData>();
    private final Map<ResourceLocation, List<String>> subBiomeData = new HashMap<ResourceLocation, List<String>>();
    private final Map<ResourceLocation, BiomeManager.BiomeEntry> biomeEntries = new HashMap<ResourceLocation, BiomeManager.BiomeEntry>();

    public BiomeDataManager(String folderName) {
        super(GSON, folderName);
    }

    public BiomeDataManager() {
        this("biomes");
    }

    protected void apply(Map<ResourceLocation, JsonObject> locations, IResourceManager resourceManager, IProfiler profiler) {
        locations.forEach((resourceLocation, object) -> {
            try {
                IResource resource = resourceManager.func_199002_a(this.getPreparedPath((ResourceLocation)resourceLocation));
                InputStream inputStream = resource.func_199027_b();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                Dynamic rootDynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class));
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((Closeable)resource);
                if (rootDynamic.getValue() == null) {
                    LibraryEx.LOGGER.error("Couldn't load {} biome config from {} data pack.", (Object)resource.func_199029_a(), (Object)resource.func_199026_d());
                } else {
                    Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(rootDynamic.get("biome").asString("")));
                    if (biome != null) {
                        ResourceLocation biomeName = biome.getRegistryName();
                        int generationWeight = rootDynamic.get("generation_weight").asInt(10);
                        if (generationWeight > 0) {
                            JsonObject rootObject = ((JsonElement)rootDynamic.getValue()).getAsJsonObject();
                            boolean useDefaultEntities = JSONUtils.func_151209_a((JsonObject)rootObject, (String)"use_default_entities", (boolean)true);
                            boolean useDefaultCarvers = JSONUtils.func_151209_a((JsonObject)rootObject, (String)"use_default_carvers", (boolean)true);
                            boolean useDefaultFeatures = JSONUtils.func_151209_a((JsonObject)rootObject, (String)"use_default_features", (boolean)true);
                            boolean useDefaultStructures = JSONUtils.func_151209_a((JsonObject)rootObject, (String)"use_default_structures", (boolean)true);
                            boolean isSubBiome = ((JsonElement)rootDynamic.getValue()).getAsJsonObject().get("is_sub_biome").getAsBoolean();
                            Map blocks = rootDynamic.get("blocks").asMap(BiomeData.BlockType::deserialize, BlockState::func_215698_a);
                            List entities = rootDynamic.get("entities").asList(entityDynamic -> {
                                EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityDynamic.get("type").asString("minecraft:pig")));
                                int spawnWeight = entityDynamic.get("spawn_weight").asInt(10);
                                int minimumGroupCount = entityDynamic.get("minimum_group_count").asInt(1);
                                int maximumGroupCount = entityDynamic.get("maximum_group_count").asInt(4);
                                return new Biome.SpawnListEntry(entityType, spawnWeight, minimumGroupCount, maximumGroupCount);
                            });
                            Map carvers = rootDynamic.get("carvers").asStream().collect(Collectors.toMap(Function.identity(), carversDynamic -> {
                                WorldCarver configuredCarver = (WorldCarver)Registry.field_218377_o.func_82594_a(new ResourceLocation(carversDynamic.get("carver").orElseEmptyMap().get("name").asString("")));
                                ProbabilityConfig carverConfig = ProbabilityConfig.func_214645_a((Dynamic)carversDynamic.get("decorator").orElseEmptyMap().get("config").orElseEmptyMap());
                                return new ConfiguredCarver(configuredCarver, (ICarverConfig)carverConfig);
                            }));
                            Map features = rootDynamic.get("features").asStream().collect(Collectors.toMap(Function.identity(), featuresDynamic -> {
                                ConfiguredFeature configuredFeature = ConfiguredFeature.func_222736_a((Dynamic)featuresDynamic.get("feature").orElseEmptyMap());
                                ConfiguredPlacement configuredPlacement = ConfiguredPlacement.func_215095_a((Dynamic)featuresDynamic.get("decorator").orElseEmptyMap());
                                return new ConfiguredFeature(Feature.field_214483_aK, (IFeatureConfig)new DecoratedFeatureConfig(configuredFeature, configuredPlacement));
                            }));
                            Map structures = rootDynamic.get("structures").asStream().collect(Collectors.toMap(Function.identity(), structuresDynamic -> {
                                ConfiguredFeature configuredFeature = ConfiguredFeature.func_222736_a((Dynamic)structuresDynamic.get("structure").orElseEmptyMap());
                                ConfiguredPlacement configuredPlacement = ConfiguredPlacement.func_215095_a((Dynamic)structuresDynamic.get("decorator").orElseEmptyMap());
                                return new ConfiguredFeature(Feature.field_214483_aK, (IFeatureConfig)new DecoratedFeatureConfig(configuredFeature, configuredPlacement));
                            }));
                            List subBiomes = rootDynamic.get("sub_biomes").asList(subBiomeDynamic -> subBiomeDynamic.asString(""));
                            BiomeData biomeData2 = this.createBiomeData(biome, generationWeight, useDefaultEntities, useDefaultCarvers, useDefaultFeatures, useDefaultStructures, isSubBiome);
                            blocks.forEach(biomeData2::addBiomeBlock);
                            entities.forEach(biomeData2::addEntitySpawn);
                            carvers.forEach((carverDynamic, configuredCarver) -> {
                                GenerationStage.Carving stage = Stream.of(GenerationStage.Carving.values()).filter(value -> value.func_222671_a().equalsIgnoreCase(carverDynamic.get("stage").asString("").toUpperCase())).findAny().orElse(GenerationStage.Carving.AIR);
                                biomeData2.addCarver(stage, (ConfiguredCarver<?>)configuredCarver);
                            });
                            features.forEach((featureDynamic, configuredFeature) -> {
                                GenerationStage.Decoration stage = Stream.of(GenerationStage.Decoration.values()).filter(value -> value.func_222676_a().equalsIgnoreCase(featureDynamic.get("stage").asString("").toUpperCase())).findAny().orElse(GenerationStage.Decoration.RAW_GENERATION);
                                biomeData2.addFeature(stage, (ConfiguredFeature<?>)configuredFeature);
                            });
                            structures.forEach((featureDynamic, configuredFeature) -> {
                                DecoratedFeatureConfig decoratedFeatureConfig = (DecoratedFeatureConfig)configuredFeature.field_222738_b;
                                Feature feature = decoratedFeatureConfig.field_214689_a.field_222737_a;
                                IFeatureConfig config = decoratedFeatureConfig.field_214689_a.field_222738_b;
                                if (feature instanceof Structure) {
                                    Structure structure = (Structure)feature;
                                    biomeData2.addStructure(structure, config);
                                    GenerationStage.Decoration stage = Stream.of(GenerationStage.Decoration.values()).filter(value -> value.func_222676_a().equalsIgnoreCase(featureDynamic.get("stage").asString("").toUpperCase())).findAny().orElse(GenerationStage.Decoration.RAW_GENERATION);
                                    biomeData2.addFeature(stage, (ConfiguredFeature<?>)configuredFeature);
                                }
                            });
                            this.biomeData.put(biomeName, biomeData2);
                            this.subBiomeData.put(biomeName, subBiomes);
                            if (!biomeData2.isSubBiome()) {
                                this.biomeEntries.put(biomeName, new BiomeManager.BiomeEntry(biome, generationWeight));
                            }
                        }
                    }
                }
                for (Map.Entry<ResourceLocation, List<String>> entry : this.subBiomeData.entrySet()) {
                    BiomeData biomeData3 = this.biomeData.get(entry.getKey());
                    if (biomeData3 == null) continue;
                    for (String subBiomeName : entry.getValue()) {
                        BiomeData subBiomeData = this.biomeData.get(new ResourceLocation(subBiomeName));
                        if (subBiomeData == null) continue;
                        biomeData3.addSubBiome(subBiomeData);
                    }
                }
                this.biomeData.forEach((location, biomeData) -> biomeData.configureBiome());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public BiomeData createBiomeData(Biome biome, int generationWeight, boolean useDefaultEntities, boolean useDefaultCarvers, boolean useDefaultFeatures, boolean useDefaultStructures, boolean isSubBiome) {
        return new BiomeData(biome, generationWeight, useDefaultEntities, useDefaultCarvers, useDefaultFeatures, useDefaultStructures, isSubBiome);
    }

    public BiomeData registerBiomeData(BiomeData biomeData) {
        Biome biome = biomeData.getBiome();
        ResourceLocation biomeName = biome.getRegistryName();
        this.biomeData.put(biomeName, biomeData);
        this.subBiomeData.put(biomeName, biomeData.getSubBiomes().stream().map(subBiomeData -> subBiomeData.getBiome().getRegistryName().toString()).collect(Collectors.toList()));
        if (!biomeData.isSubBiome()) {
            this.biomeEntries.put(biomeName, new BiomeManager.BiomeEntry(biome, biomeData.getGenerationWeight()));
        }
        return biomeData;
    }

    public void unregisterBiomeData(BiomeData biomeData) {
        ResourceLocation biomeName = biomeData.getBiome().getRegistryName();
        this.biomeData.remove(biomeName);
        this.subBiomeData.remove(biomeName);
        this.biomeEntries.remove(biomeName);
    }

    public void cleanup() {
        this.biomeData.forEach((resourceLocation, biomeData) -> biomeData.resetBiome());
        this.biomeData.clear();
        this.subBiomeData.clear();
        this.biomeEntries.clear();
    }

    public BiomeData getBiomeData(Biome biome) {
        return this.biomeData.getOrDefault(biome.getRegistryName(), BiomeData.EMPTY);
    }

    public Map<ResourceLocation, BiomeData> getBiomeData() {
        return Collections.unmodifiableMap(this.biomeData);
    }

    public Map<ResourceLocation, BiomeManager.BiomeEntry> getBiomeEntries() {
        return Collections.unmodifiableMap(this.biomeEntries);
    }
}

