/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.feature;

import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class OreFeature
extends Feature<Config> {
    public OreFeature(Function<Dynamic<?>, ? extends Config> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, Config config) {
        float angle = random.nextFloat() * (float)Math.PI;
        float multiplier = (float)config.getSize() / 8.0f;
        int offset = MathHelper.func_76123_f((float)(((float)config.getSize() / 16.0f * 2.0f + 1.0f) / 2.0f));
        double d0 = (float)pos.func_177958_n() + MathHelper.func_76126_a((float)angle) * multiplier;
        double d1 = (float)pos.func_177958_n() - MathHelper.func_76126_a((float)angle) * multiplier;
        double d2 = (float)pos.func_177952_p() + MathHelper.func_76134_b((float)angle) * multiplier;
        double d3 = (float)pos.func_177952_p() - MathHelper.func_76134_b((float)angle) * multiplier;
        double d4 = pos.func_177956_o() + random.nextInt(3) - 2;
        double d5 = pos.func_177956_o() + random.nextInt(3) - 2;
        int maxX = pos.func_177958_n() - MathHelper.func_76123_f((float)multiplier) - offset;
        int maxY = pos.func_177956_o() - 2 - offset;
        int maxZ = pos.func_177952_p() - MathHelper.func_76123_f((float)multiplier) - offset;
        int j1 = 2 * (MathHelper.func_76123_f((float)multiplier) + offset);
        int k1 = 2 * (2 + offset);
        for (int posX = maxX; posX <= maxX + j1; ++posX) {
            for (int posZ = maxZ; posZ <= maxZ + j1; ++posZ) {
                if (maxY > world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, posX, posZ)) continue;
                return this.spawnOre(world, random, config, d0, d1, d2, d3, d4, d5, maxX, maxY, maxZ, j1, k1);
            }
        }
        return false;
    }

    private boolean spawnOre(IWorld world, Random random, Config config, double p_207803_4_, double p_207803_6_, double p_207803_8_, double p_207803_10_, double p_207803_12_, double p_207803_14_, int maxX, int maxY, int maxZ, int width, int height) {
        int size;
        int placements = 0;
        BitSet bitset = new BitSet(width * height * width);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        double[] adouble = new double[config.getSize() * 4];
        for (size = 0; size < config.getSize(); ++size) {
            float f = (float)size / (float)config.getSize();
            double d0 = MathHelper.func_219803_d((double)f, (double)p_207803_4_, (double)p_207803_6_);
            double d2 = MathHelper.func_219803_d((double)f, (double)p_207803_12_, (double)p_207803_14_);
            double d4 = MathHelper.func_219803_d((double)f, (double)p_207803_8_, (double)p_207803_10_);
            double d6 = random.nextDouble() * (double)config.getSize() / 16.0;
            double d7 = ((double)(MathHelper.func_76126_a((float)((float)Math.PI * f)) + 1.0f) * d6 + 1.0) / 2.0;
            adouble[size * 4 + 0] = d0;
            adouble[size * 4 + 1] = d2;
            adouble[size * 4 + 2] = d4;
            adouble[size * 4 + 3] = d7;
        }
        for (size = 0; size < config.getSize() - 1; ++size) {
            if (adouble[size * 4 + 3] <= 0.0) continue;
            for (int j3 = size + 1; j3 < config.getSize(); ++j3) {
                double d14;
                double d13;
                double d12;
                double d15;
                if (adouble[j3 * 4 + 3] <= 0.0 || !((d15 = adouble[size * 4 + 3] - adouble[j3 * 4 + 3]) * d15 > (d12 = adouble[size * 4 + 0] - adouble[j3 * 4 + 0]) * d12 + (d13 = adouble[size * 4 + 1] - adouble[j3 * 4 + 1]) * d13 + (d14 = adouble[size * 4 + 2] - adouble[j3 * 4 + 2]) * d14)) continue;
                if (d15 > 0.0) {
                    adouble[j3 * 4 + 3] = -1.0;
                    continue;
                }
                adouble[size * 4 + 3] = -1.0;
            }
        }
        for (size = 0; size < config.getSize(); ++size) {
            double d11 = adouble[size * 4 + 3];
            if (d11 < 0.0) continue;
            double d1 = adouble[size * 4 + 0];
            double d3 = adouble[size * 4 + 1];
            double d5 = adouble[size * 4 + 2];
            int startX = Math.max(MathHelper.func_76128_c((double)(d1 - d11)), maxX);
            int startY = Math.max(MathHelper.func_76128_c((double)(d3 - d11)), maxY);
            int startZ = Math.max(MathHelper.func_76128_c((double)(d5 - d11)), maxZ);
            int sizeX = Math.max(MathHelper.func_76128_c((double)(d1 + d11)), startX);
            int sizeY = Math.max(MathHelper.func_76128_c((double)(d3 + d11)), startY);
            int sizeZ = Math.max(MathHelper.func_76128_c((double)(d5 + d11)), startZ);
            for (int posX = startX; posX <= sizeX; ++posX) {
                double d8 = ((double)posX + 0.5 - d1) / d11;
                if (!(d8 * d8 < 1.0)) continue;
                for (int posY = startY; posY <= sizeY; ++posY) {
                    double d9 = ((double)posY + 0.5 - d3) / d11;
                    if (!(d8 * d8 + d9 * d9 < 1.0)) continue;
                    for (int posZ = startZ; posZ <= sizeZ; ++posZ) {
                        int k2;
                        double d10 = ((double)posZ + 0.5 - d5) / d11;
                        if (!(d8 * d8 + d9 * d9 + d10 * d10 < 1.0) || bitset.get(k2 = posX - maxX + (posY - maxY) * width + (posZ - maxZ) * width * height)) continue;
                        bitset.set(k2);
                        mutablePos.func_181079_c(posX, posY, posZ);
                        if (config.getTargetState() != world.func_180495_p((BlockPos)mutablePos)) continue;
                        world.func_180501_a((BlockPos)mutablePos, config.getOreState(), 2);
                        ++placements;
                    }
                }
            }
        }
        return placements > 0;
    }

    public static class Config
    implements IFeatureConfig {
        private final BlockState oreState;
        private final BlockState targetState;
        private final int size;

        public Config(BlockState oreState, BlockState targetState, int size) {
            this.oreState = oreState;
            this.targetState = targetState;
            this.size = size;
        }

        public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put(ops.createString("ore_state"), BlockState.func_215689_a(ops, (BlockState)this.oreState).getValue());
            map.put(ops.createString("target_state"), BlockState.func_215689_a(ops, (BlockState)this.targetState).getValue());
            map.put(ops.createString("size"), ops.createInt(this.size));
            return new Dynamic(ops, ops.createMap(map));
        }

        public static <T> Config deserialize(Dynamic<T> dynamic) {
            BlockState oreState = dynamic.get("ore_state").map(BlockState::func_215698_a).orElse(Blocks.field_150350_a.func_176223_P());
            BlockState targetState = dynamic.get("target_state").map(BlockState::func_215698_a).orElse(Blocks.field_150350_a.func_176223_P());
            int size = dynamic.get("size").asInt(0);
            return new Config(oreState, targetState, size);
        }

        public BlockState getOreState() {
            return this.oreState;
        }

        public BlockState getTargetState() {
            return this.targetState;
        }

        public int getSize() {
            return this.size;
        }
    }
}

