/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.feature;

import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class ScatterFeature
extends Feature<Config> {
    public ScatterFeature(Function<Dynamic<?>, ? extends Config> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, Config config) {
        BlockState scatterState = config.getScatterState();
        Config.TargetArea targetArea = config.getTargetArea();
        for (int i = 0; i < 64; ++i) {
            BlockPos randomPos = pos.func_177982_a(random.nextInt(8) - random.nextInt(8), random.nextInt(4) - random.nextInt(4), random.nextInt(8) - random.nextInt(8));
            if (!world.func_175623_d(randomPos)) continue;
            BlockPos offsetPos = targetArea.offsetPos(randomPos);
            if ((targetArea == Config.TargetArea.ON_GROUND || targetArea == Config.TargetArea.IN_GROUND) && world.func_180495_p(randomPos.func_177977_b()) == config.getTargetState()) {
                if (!scatterState.func_196955_c((IWorldReader)world, offsetPos)) continue;
                world.func_180501_a(offsetPos, scatterState, 2);
                continue;
            }
            if (targetArea != Config.TargetArea.ON_ROOF && targetArea != Config.TargetArea.IN_ROOF || world.func_180495_p(randomPos.func_177984_a()) != config.getTargetState() || !scatterState.func_196955_c((IWorldReader)world, offsetPos)) continue;
            world.func_180501_a(offsetPos, scatterState, 2);
        }
        return true;
    }

    public static class Config
    implements IFeatureConfig {
        private final BlockState scatterState;
        private final BlockState targetState;
        private final TargetArea targetArea;

        public Config(BlockState scatterState, BlockState targetState, TargetArea targetArea) {
            this.scatterState = scatterState;
            this.targetState = targetState;
            this.targetArea = targetArea;
        }

        public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put(ops.createString("scatter_state"), BlockState.func_215689_a(ops, (BlockState)this.scatterState).getValue());
            map.put(ops.createString("target_state"), BlockState.func_215689_a(ops, (BlockState)this.targetState).getValue());
            map.put(ops.createString("target_area"), ops.createString(this.targetArea.toString()));
            return new Dynamic(ops, ops.createMap(map));
        }

        public static <T> Config deserialize(Dynamic<T> dynamic) {
            BlockState scatterState = dynamic.get("scatter_state").map(BlockState::func_215698_a).orElse(Blocks.field_150350_a.func_176223_P());
            BlockState targetState = dynamic.get("target_state").map(BlockState::func_215698_a).orElse(Blocks.field_150350_a.func_176223_P());
            TargetArea targetArea = dynamic.get("target_area").map(TargetArea::deserialize).orElse(TargetArea.ON_GROUND);
            return new Config(scatterState, targetState, targetArea);
        }

        public BlockState getScatterState() {
            return this.scatterState;
        }

        public BlockState getTargetState() {
            return this.targetState;
        }

        public TargetArea getTargetArea() {
            return this.targetArea;
        }

        private static enum TargetArea {
            ON_GROUND(null),
            IN_GROUND(Direction.DOWN),
            ON_ROOF(null),
            IN_ROOF(Direction.UP);

            Direction offset;

            private TargetArea(Direction offset) {
                this.offset = offset;
            }

            public static <T> TargetArea deserialize(Dynamic<T> dynamic) {
                for (TargetArea area : TargetArea.values()) {
                    if (!dynamic.get("target_area").asString().orElse("").equals(area.toString())) continue;
                    return area;
                }
                return ON_GROUND;
            }

            public BlockPos offsetPos(BlockPos pos) {
                if (this.offset != null) {
                    return pos.func_177972_a(this.offset);
                }
                return pos;
            }

            public Direction getOffset() {
                return this.offset;
            }

            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }
}

