/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant;

import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import java.nio.file.Paths;
import logictechcorp.libraryex.resource.BuiltinDataPack;
import logictechcorp.reagenchant.ReagenchantConfig;
import logictechcorp.reagenchant.block.ReagenchantBlocks;
import logictechcorp.reagenchant.client.gui.screen.ReagentTableScreen;
import logictechcorp.reagenchant.client.renderer.tileentity.ReagentTableTileEntityRenderer;
import logictechcorp.reagenchant.command.ReagenchantCommand;
import logictechcorp.reagenchant.inventory.container.ReagenchantContainers;
import logictechcorp.reagenchant.item.ReagenchantItems;
import logictechcorp.reagenchant.network.item.reagent.MessageSUpdateReagentsPacket;
import logictechcorp.reagenchant.reagent.ReagentManager;
import logictechcorp.reagenchant.tileentity.ReagenchantTileEntityTypes;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="reagenchant")
public class Reagenchant {
    public static final String MOD_ID = "reagenchant";
    public static final String NETWORK_VERSION = "reagenchant_network_1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("reagenchant", "network"), () -> "reagenchant_network_1", "reagenchant_network_1"::equals, "reagenchant_network_1"::equals);
    public static final ReagentManager REAGENT_MANAGER = new ReagentManager();
    public static final Logger LOGGER = LogManager.getLogger((String)"Reagenchant");

    public Reagenchant() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(this::onClientSetup));
        ReagenchantBlocks.BLOCK_OVERRIDES.register(modEventBus);
        ReagenchantItems.ITEM_OVERRIDES.register(modEventBus);
        ReagenchantTileEntityTypes.TILE_ENTITY_TYPE_OVERRIDES.register(modEventBus);
        ReagenchantContainers.CONTAINERS.register(modEventBus);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(this::onServerAboutToStart);
        forgeEventBus.addListener(this::onServerStarting);
        forgeEventBus.addListener(this::onPlayerLoggedIn);
        forgeEventBus.addListener(this::onServerStopping);
        this.registerMessages();
        ReagenchantConfig.registerConfigs();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onClientSetup(FMLClientSetupEvent event) {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ReagenchantTileEntityTypes.REAGENT_TABLE_TILE_ENTITY.get()), ReagentTableTileEntityRenderer::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ReagenchantContainers.REAGENT_TABLE_CONTAINER.get()), ReagentTableScreen::new);
    }

    private void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        ResourcePackList resourcePacks = server.func_195561_aH();
        ModFile modFile = ModList.get().getModFileById(MOD_ID).getFile();
        if (((Boolean)ReagenchantConfig.COMMON.reagentPackUseGlobalReagentPacks.get()).booleanValue()) {
            Path globalBiomePacksPath = FMLPaths.getOrCreateGameRelativePath((Path)FMLPaths.CONFIGDIR.get().resolve(Paths.get(MOD_ID, "reagent_packs")), (String)"reagenchant reagent packs");
            resourcePacks.func_198982_a((IPackFinder)new FolderPackFinder(globalBiomePacksPath.toFile()));
        }
        if (((Boolean)ReagenchantConfig.COMMON.reagentPackUseReagenchantReagentPack.get()).booleanValue()) {
            resourcePacks.func_198982_a((IPackFinder)new BuiltinDataPack(modFile, "reagent_pack"));
        }
        server.func_195570_aG().func_219534_a((IFutureReloadListener)REAGENT_MANAGER);
    }

    private void onServerStarting(FMLServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getCommandDispatcher();
        ReagenchantCommand.register((CommandDispatcher<CommandSource>)dispatcher);
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        World world = player.func_130014_f_();
        if (!world.func_201670_d()) {
            CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageSUpdateReagentsPacket(REAGENT_MANAGER.getReagents().values()));
        }
    }

    private void onServerStopping(FMLServerStoppingEvent event) {
        REAGENT_MANAGER.cleanup();
    }

    private void registerMessages() {
        CHANNEL.messageBuilder(MessageSUpdateReagentsPacket.class, 0).encoder(MessageSUpdateReagentsPacket::serialize).decoder(MessageSUpdateReagentsPacket::deserialize).consumer(MessageSUpdateReagentsPacket::handle).add();
    }
}

